*******************************************************************************
* 
*    Kmat - A matboard cutting calculator
*    Copyright (C)  2024 : Kurt Ebert
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the license, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see {<http:*www.gnu.org/licenses/>}
*
*    Web   : www.kurtebertphoto.com/kmat/
*    Email : kurt@kurtebertphoto.com
* 
*******************************************************************************
* 
*    Kmat Version 9.00 -- (6.2024)
*    HMG Version 3.4.1 (Compiler)
* 
*******************************************************************************

#include "hmg.ch"
d_declare ()
FUNCTION Main()
d_Pvars ()
d_Psets ()
d_main_win ()
RETURN NIL

*******************************************************************************

Function d_main_win ()
 DEFINE WINDOW Form_1 AT 100,100 WIDTH 920 HEIGHT 687 NOMAXIMIZE NOSIZE TITLE "Kmat - Matboard Calculator  /  Version 9.00  /  6.2024" MAIN
  END WINDOW
   d_keys ()
   d_Image_photo ()
   d_kmat_lic ()
   d_kmat_help ()
   d_kmat_extra ()
   d_main_menu ()
   d_main_window_fields ()
   Errorbox()
  END WINDOW
 ACTIVATE WINDOW Form_1
RETURN NIL

*******************************************************************************

* Drawing of an error box at project area if math error or bad data entered
Function Errorbox()
   DRAW RECTANGLE IN WINDOW Form_1 AT 85,310 TO 364,702 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {255,255,255}
   DRAW RECTANGLE IN WINDOW Form_1 AT 117,352 TO 312,660 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {180,180,180}
   DRAW RECTANGLE IN WINDOW Form_1 AT 125,360 TO 304,652 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {80,80,80}
   DRAW LINE IN WINDOW Form_1 AT 145,385 TO 284,632 PENCOLOR {255,153,0} PENWIDTH 1
   DRAW LINE IN WINDOW Form_1 AT 284,385 TO 145,632 PENCOLOR {255,153,0} PENWIDTH 1
RETURN NIL

*******************************************************************************

* Main function to draw mat board project
FUNCTION Matcalc()
      CleanSlate ()
      R_Pics ()
         if  Form_1.V1.value>0 .and. Form_1.V2.value>0 .and. Form_1.V3.value>0 .and. Form_1.V4.value>0
            Kcalc := 1
            Kphoto:= 0
            Math_pvars ()
            math_get_check ()
            mat_math ()
               if W3< 0 .or. W4< 0 .or. W5< 0 .or. W6< 0 .or. W7< 0 .or. W8< 0 .or. L3< 0 .or. L4< 0 .or. L5< 0 .or. L6< 0 .or. L7< 0 .or. L8< 0
                  Kcalc := 0
                  math_error ()
                  ERASE WINDOW Form_1
                  * matcut()
                  errorbox()
               else
                  Form_1.Restore
                  * matcut()
                     if  matw>0 .and. matl>0 .and. picw>0 .and. picl>0 .and. picw<matw .and. picl<matl .and. picw<=picl .and. matw<=matl
                        paint_mat ()
                     else
                        zero_fields ()
                        ERASE WINDOW Form_1
                        * matcut()
                        errorbox()
                     endif
               endif
         endif
RETURN NIL

************************************************************************************************

* define public mem vars for math functions
Function Math_pvars ()
   Public Kname, cm, matw, matl, picw, picl, overlap, m12, m23, offw, offl, arx, ark
   Public rabit, matw_I, matl_I, picw_I, picl_I, matwidth, matlength, picwidth, piclength
   Public K1, K2, K3, K4, K5, U1, U2, U3, R1, R2, R3, R4, R5, T1, T2, T3
   Public x, y, x2, y2, vMax, S1, S2, xx2, yy2, xx, yy
   Public W3, W4, W5, W6, W7, W8, L3, L4, L5, L6, L7, L8
   Public yp, xxp, yyp, x2p, y2p, xx2p, yy2p
*
   Public AR, Golden
   Public calcin, calcout
   Public TargetMW, TargetML, TargetWS,  TargetAR,  TargetWP,  TargetLP, TargetPW, TargetPL
   Public kar_w, kar_l, kar_A
   Public mm2Id_mm, mm2Id_Id, Kstrmm, Photo_Border_R
RETURN NIL

************************************************************************************************

* get form values and check inch vs mm
Function  math_get_check ()
   matwidth  := Form_1.V1.value
   matlength := Form_1.V2.value 
   picwidth  := Form_1.V3.value
   piclength := Form_1.V4.value
   overlap   := Form_1.V5.value
   m12       := Form_1.V6.value 
   m23       := Form_1.V7.value
   offw      := Form_1.V8.value
   offl      := Form_1.V9.value
   Kname     := Form_1.V10.value
   cm        := 25.40
   rabit     := 14

    if KJE = 1
     piclength = Form_1.V4.value
     picwidth = piclength/ark
     Form_1.V3.value  := picwidth
    else
     arx = piclength/picwidth
     Form_1.V61.value := arx
    endif

   if matwidth <= 60 
      matw   := cm*matwidth
      matw_I := matwidth
   else
      matw   := matwidth
      matw_I := round((matwidth/cm),2)
   endif

   if matlength <= 60
      matl := cm*matlength
      matl_I := matlength
   else
      matl := matlength
      matl_I := round((matlength/cm),2)
   endif

   if picwidth < 59
      picw   := cm*picwidth
      picw_I := picwidth
   else
      picw   := picwidth
      picw_I := round((picwidth/cm),2)
   endif

   if piclength < 59
      picl := cm*piclength
      picl_I := piclength
   else
      picl := piclength
      picl_I := round((piclength/cm),2)
   endif

Form_1.V60.value := (matl_I)/(matw_I)
Form_1.V66.value := (picw_I*picl_I)/((matw_I*matl_I)-(picw_I*picl_I))
Form_1.V65.value := round(100-((round(((picl_I/matl_I)*100),1)+round(((picw_I/matw_I)*100),1))/2),1)
Form_1.V63.value := round(((picl_I/matl_I)*100),1)
Form_1.V62.value := round(((picw_I/matw_I)*100),1)

if overlap = 0
  overlap := 0.1
   if (overlap*2) > (picw/2)
      Form_1.V5.value := 0
   endif
endif
RETURN NIL

************************************************************************************************

* Math behind the answers
FUNCTION mat_math ()

   vMax  :=(392/matl)
   x     := 80
   y     := 310
   xx    := x+(matw*vmax)
   yy    := y+(matl*vmax)
 
   yp    := y+(392-(matw*vmax))/2
   xxp   := x+(matl*vmax)
   yyp   := yp+(matw*vmax)

   s1    := ((Matw-Picw)/2)
   s2    := ((Matl-Picl)/2)
 
   x2    := x+(((S1)+(overlap)-(Offw))*vmax)
   y2    := y+(((S2)+(overlap)+(Offl))*vmax)
   xx2   := x+(((s1+picw)-(overlap)-(Offw))*vmax)
   yy2   := y+(((S2+picl)-(overlap)+(Offl))*vmax)

   x2p   := x+(((S2)+(overlap)-(offl))*vmax)
   y2p   := yp+(((S1)+(overlap))-(offw))*vmax
   xx2p  := x+(((S2+picl)-(overlap)-(Offl))*vmax)
   yy2p  := yp+(((S1+picw)-(overlap))-(offw))*vmax

   AR    := Round(((picl/picw)*100),0)
   gold  := (matl/matw) 

   K1    := (matw-rabit)+(picw-(2*overlap))
   K2    := (matl-rabit)-(picl-(2*overlap))
   K3    := 4*(matw-rabit)
   K4    := K1*K2
   K5    := K4/K3
   U1    := (matl-rabit)-(picl-(2*overlap))
   U2    := U1/2
   U3    := Round((U2-K5),0)
   R1    := (matl-rabit)+(picl-(2*overlap))
   R2    := (matw-rabit)-(picw-(2*overlap))
   R3    := 4*(matl-rabit) 
   R4    := R1*R2
   R5    := R4/R3
   T1    := (matw-rabit)-(picw-(2*overlap))
   T2    := T1/2
   T3    := round((T2-R5),0)

   W3=(((matw-picw)+2*Overlap)/2)-offw
   W4=(((matw-picw)+2*Overlap)/2)+offw
   L3=(((matl-picl)+2*Overlap)/2)-offl
   L4=(((matl-picl)+2*Overlap)/2)+offl

   if m12 > 0
      W5=W3-m12
      L5=L3-m12
      W6=W4-m12
      L6=L4-m12
   else
      W5=0
      W6=0
      L5=0
      L6=0
      Form_1.V6.value := 0
   endif

   if m23 > 0 .and. m12> 0
      W7=W5-m23
      L7=L5-m23
      W8=W6-m23
      L8=L6-m23
   else
      W7=0
      W8=0
      L7=0
      L8=0
      Form_1.V7.value := 0
   endif

   if m23 > 0 .and. m12 = 0 
      Form_1.V7.value := 0
   endif

   if matw > matl 
      Form_1.V1.value := 0
   endif

   if picw > picl  
      Form_1.V3.value := 0
   endif

   Kname = ltrim(trim(Kname))
   if len(Kname) > 25
      Kname = substr(Kname,1,25)
   endif
   Form_1.V10.value :=  Kname

    Form_1.V20.value  := T3
    Form_1.V30.value  := U3
    Form_1.V50.value  := space(12)

   	Form_1.L2001.value := mm2fract(round(overlap,1)) 
   	Form_1.L2002.value := mm2fract(round(m12,1)) 
   	Form_1.L2003.value := mm2fract(round(m23,1)) 
    Form_1.L2004.value := mm2fract(round(offw,1)) 
    Form_1.L2005.value := mm2fract(round(offl,1)) 

    Form_1.A1.value := mm2fract(round(matw,1))
    Form_1.A2.value := mm2fract(round(matl,1))
    Form_1.A3.value := mm2fract(round(picw,1))
    Form_1.A4.value := mm2fract(round(picl,1))

   	Form_1.L1005.value := mm2fract(round(w3,1)) 
	Form_1.L1015.value := mm2fract(round(w4,1))
	Form_1.L1025.value := mm2fract(round(L3,1))
	Form_1.L1035.value := mm2fract(round(L4,1))
	Form_1.L1045.value := mm2fract(round(w5,1))
	Form_1.L1055.value := mm2fract(round(w6,1))
	Form_1.L1065.value := mm2fract(round(l5,1))
	Form_1.L1075.value := mm2fract(round(l6,1))
	Form_1.L1085.value := mm2fract(round(w7,1))
	Form_1.L1095.value := mm2fract(round(w8,1))
  	Form_1.L1105.value := mm2fract(round(l7,1))
  	Form_1.L1115.value := mm2fract(round(l8,1))

  	Form_1.V60.value  := gold
   	Form_1.V100.value := round(w3,0)
   	Form_1.V101.value := round(w4,0)
   	Form_1.V102.value := round(l3,0)
   	Form_1.V103.value := round(l4,0)
   	Form_1.V104.value := round(w5,0)
 	Form_1.V105.value := round(w6,0)
    Form_1.V106.value := round(l5,0)
    Form_1.V107.value := round(l6,0)
    Form_1.V108.value := round(w7,0)
    Form_1.V109.value := round(w8,0)
    Form_1.V110.value := round(l7,0)
    Form_1.V111.value := round(l8,0)

RETURN NIL

************************************************************************************************

* If math error, clear mem and 0 fields
FUNCTION math_error ()

   W3 := 0
   W4 := 0
   W5 := 0
   W6 := 0
   W7 := 0
   W8 := 0
   L3 := 0
   L4 := 0
   L5 := 0
   L6 := 0
   L7 := 0
   L8 := 0

   Form_1.V100.value := round(w3,0)
   Form_1.V101.value := round(w4,0)
   Form_1.V102.value := round(l3,0)
   Form_1.V103.value := round(l4,0)
   Form_1.V104.value := round(w5,0)
   Form_1.V105.value := round(w6,0)
   Form_1.V106.value := round(l5,0)
   Form_1.V107.value := round(l6,0)
   Form_1.V108.value := round(w7,0)
   Form_1.V109.value := round(w8,0)
   Form_1.V110.value := round(l7,0)
   Form_1.V111.value := round(l8,0)

RETURN NIL

************************************************************************************************

* draw the mat project and load picture
FUNCTION paint_mat ()

   if HV > 0
      DRAW RECTANGLE IN WINDOW Form_1 AT x-20,y-20 TO x+392+20,y+392+20 PENCOLOR {212,208,200} PENWIDTH 0 FILLCOLOR {212,208,200}
      DRAW RECTANGLE IN WINDOW Form_1 AT x,yp TO xxp,yyp PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {255,255,255}

         if m23 > 0 .and. m12> 0
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2p-((m12+m23)*vmax))-1, (y2p-((m12+m23)*vmax))-1 TO (xx2p+((m12+m23)*vmax))+1, (yy2p+((m12+m23)*vmax))+1 PENCOLOR {128,128,128} PENWIDTH 1 FILLCOLOR {180,180,180}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2p-((m12+m23)*vmax)), (y2p-((m12+m23)*vmax)) TO (xx2p+((m12+m23)*vmax)), (yy2p+((m12+m23)*vmax)) PENCOLOR {255,255,255} PENWIDTH 1 FILLCOLOR {180,180,180}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2p-((m12+m23)*vmax))+1, (y2p-((m12+m23)*vmax))+1 TO (xx2p+((m12+m23)*vmax))-1, (yy2p+((m12+m23)*vmax))-1 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {180,180,180}
         endif

         if m12 > 0
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2p-((m12)*vmax))-1, (y2p-((m12)*vmax))-1 TO (xx2p+((m12)*vmax))+1, (yy2p+((m12)*vmax))+1 PENCOLOR {128,128,128} PENWIDTH 1 FILLCOLOR {210,210,210}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2p-((m12)*vmax)), (y2p-((m12)*vmax)) TO (xx2p+((m12)*vmax)), (yy2p+((m12)*vmax)) PENCOLOR {255,255,255} PENWIDTH 1 FILLCOLOR {210,210,210}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2p-((m12)*vmax))+1, (y2p-((m12)*vmax))+1 TO (xx2p+((m12)*vmax))-1, (yy2p+((m12)*vmax))-1 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {210,210,210}
         endif

      DRAW RECTANGLE IN WINDOW Form_1 AT x2p-1,y2p-1 TO xx2p+1,yy2p+1 PENCOLOR {128,128,128} PENWIDTH 1 FILLCOLOR {80,80,80} 
      DRAW RECTANGLE IN WINDOW Form_1 AT x2p,y2p TO xx2p,yy2p PENCOLOR {255,255,255} PENWIDTH 1 FILLCOLOR {80,80,80} 
      DRAW RECTANGLE IN WINDOW Form_1 AT x2p+1,y2p+1 TO xx2p-1,yy2p-1 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {80,80,80} 
      Want_photo()

    else
   
      DRAW RECTANGLE IN WINDOW Form_1 AT x-20,y-20 TO x+392+20,y+392+20 PENCOLOR {212,208,200} PENWIDTH 0 FILLCOLOR {212,208,200}
      DRAW RECTANGLE IN WINDOW Form_1 AT x,y TO xx,yy PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {255,255,255}
         
         if m23 > 0 .and. m12> 0
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2-((m12+m23)*vmax))-1, (y2-((m12+m23)*vmax))-1 TO (xx2+((m12+m23)*vmax))+1, (yy2+((m12+m23)*vmax))+1 PENCOLOR {128,128,128} PENWIDTH 1 FILLCOLOR {180,180,180}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2-((m12+m23)*vmax)), (y2-((m12+m23)*vmax)) TO (xx2+((m12+m23)*vmax)), (yy2+((m12+m23)*vmax)) PENCOLOR {255,255,255} PENWIDTH 1 FILLCOLOR {180,180,180}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2-((m12+m23)*vmax))+1, (y2-((m12+m23)*vmax))+1 TO (xx2+((m12+m23)*vmax))-1, (yy2+((m12+m23)*vmax))-1 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {180,180,180}
         endif
  
         if m12 > 0
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2-((m12)*vmax))-1, (y2-((m12)*vmax))-1 TO (xx2+((m12)*vmax))+1, (yy2+((m12)*vmax))+1 PENCOLOR {128,128,128} PENWIDTH 1 FILLCOLOR {210,210,210}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2-((m12)*vmax)), (y2-((m12)*vmax)) TO (xx2+((m12)*vmax)), (yy2+((m12)*vmax)) PENCOLOR {255,255,255} PENWIDTH 1 FILLCOLOR {210,210,210}
            DRAW RECTANGLE IN WINDOW Form_1 AT (x2-((m12)*vmax))+1, (y2-((m12)*vmax))+1 TO (xx2+((m12)*vmax))-1, (yy2+((m12)*vmax))-1 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {210,210,210}
         endif 

      DRAW RECTANGLE IN WINDOW Form_1 AT x2-1,y2-1 TO xx2+1,yy2+1 PENCOLOR {128,128,128} PENWIDTH 1 FILLCOLOR {80,80,80}
      DRAW RECTANGLE IN WINDOW Form_1 AT x2,y2 TO xx2,yy2 PENCOLOR {255,255,255} PENWIDTH 1 FILLCOLOR {80,80,80}
      DRAW RECTANGLE IN WINDOW Form_1 AT x2+1,y2+1 TO xx2-1,yy2-1 PENCOLOR {0,0,0} PENWIDTH 1 FILLCOLOR {80,80,80}
      Want_photo()
   endif

RETURN NIL

************************************************************************************************

* Another error function to zero out mem and replace fields
FUNCTION zero_fields ()

   Kcalc  := 0
   matw   := 0
   matl   := 0
   picw   := 0
   picl   := 0
   matw_I := 0
   matl_I := 0 

   W3 := 0
   W4 := 0
   W5 := 0
   W6 := 0
   W7 := 0
   W8 := 0
   L3 := 0
   L4 := 0
   L5 := 0
   L6 := 0
   L7 := 0
   L8 := 0

RETURN NIL

************************************************************************************************

* declare main public mem vars
FUNCTION d_Pvars ()
   Public Kcalc, HV, HVM, Kphoto, Rpics, KJE
   Rpics := 0
   Kphoto:= 0
   Kcalc := 0
   HV    := 0
   HVM   := 0
   KJE   := 0
RETURN NIL

************************************************************************************************

* set navigation
FUNCTION d_Psets ()
Set Navigation Extended
RETURN NIL

************************************************************************************************

* declare help windows
  FUNCTION d_declare ()
   DECLARE WINDOW kmat_lic
   DECLARE WINDOW kmat_help
   DECLARE WINDOW kmat_extra
RETURN NIL

************************************************************************************************

* set esc key
FUNCTION d_keys ()
ON KEY ESCAPE OF FORM_1 ACTION Form_1.Release
RETURN NIL

************************************************************************************************

Function d_main_window_fields ()

   @ 32,30 LABEL L1 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Mat Width - In(d) : mm" bold
   @ 30,170 TEXTBOX V1 PARENT Form_1 WIDTH 45 NUMERIC 
   @ 35,232 Label A1  PARENT Form_1 WIDTH 60 VALUE ""

   @ 60,30 LABEL L2 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Mat Length - In(d) : mm" bold
   @ 58,170 TEXTBOX V2 PARENT Form_1 WIDTH 45 NUMERIC 
   @ 63,232 Label A2  PARENT Form_1 WIDTH 60 VALUE ""
 
   @ 88,30 LABEL L3 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Art Width - In(d) : mm" bold
   @ 86,170 TEXTBOX V3 PARENT Form_1 WIDTH 45 NUMERIC
   @ 91,232 Label A3  PARENT Form_1 WIDTH 60 VALUE ""

   @ 116,30 LABEL L4 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Art Length - In(d) : mm" bold
   @ 114,170 TEXTBOX V4 PARENT Form_1 WIDTH 45 NUMERIC 
   @ 119,232 Label A4  PARENT Form_1 WIDTH 60 VALUE ""

   @ 144,30 LABEL L5 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Mat:1 - Overlap (mm)"
   @ 142,170 TEXTBOX V5 PARENT Form_1 WIDTH 35 NUMERIC ON LOSTFOCUS Matcalc()
   @ 147,232 Label L2001 PARENT Form_1 WIDTH 60 VALUE ""
 
   @ 172,30 LABEL L6 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Mat:1 to Mat:2 (mm)"
   @ 170,170 TEXTBOX V6 PARENT Form_1 WIDTH 35 NUMERIC 
   @ 175,232 Label L2002 PARENT Form_1 WIDTH 60 VALUE ""

   @ 200,30 LABEL L7 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Mat:2 to Mat:3 (mm)"
   @ 198,170 TEXTBOX V7 PARENT Form_1 WIDTH 35 NUMERIC 
   @ 203,232 Label L2003 PARENT Form_1 WIDTH 60 VALUE ""

   @ 228,30 LABEL L8 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Landscape Offset (mm)"
   @ 226,170 TEXTBOX V8 PARENT Form_1 WIDTH 35 NUMERIC ON LOSTFOCUS Chk_Port() 
   @ 226,209 TEXTBOX V20 PARENT Form_1 WIDTH 20 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 231,232 Label L2004 PARENT Form_1 WIDTH 60 VALUE ""

   @ 256,30 LABEL L9 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Portrait Offset (mm)"
   @ 254,170 TEXTBOX V9 PARENT Form_1 WIDTH 35 NUMERIC ON LOSTFOCUS Chk_Port() 
   @ 254,209 TEXTBOX V30 PARENT Form_1 WIDTH 20 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 259,232 Label L2005 PARENT Form_1 WIDTH 60 VALUE ""

   @ 466,56 LABEL L10 PARENT Form_1 WIDTH 80 VALUE "Art (25)" 
   @ 463,105 TEXTBOX V10 PARENT Form_1 WIDTH 160
  
   @ 30,300  BUTTON B1 PARENT Form_1 CAPTION "Calculate" WIDTH 65 BOLD ONCLICK Matcalc()
   @ 113,218 BUTTON B10 PARENT Form_1 CAPTION "C" WIDTH 14 BOLD ONCLICK Matcalc()
   @ 30,370  BUTTON B2 PARENT Form_1 CAPTION "Orientation" WIDTH 75 BOLD ONCLICK Flipmat()
   @ 30,450  BUTTON B3 PARENT Form_1 CAPTION "Hide" WIDTH 35 BOLD ONCLICK Want_photo()
   @ 30,490  BUTTON B4 PARENT Form_1 CAPTION "Pdf" WIDTH 30 BOLD ONCLICK Pdfprt()
   @ 30,525  BUTTON B6 PARENT Form_1 CAPTION "Txt" WIDTH 30 BOLD ONCLICK TxtPrt()
   @ 30,560  BUTTON B7 PARENT Form_1 CAPTION "Screen" WIDTH 70 BOLD ONCLICK Screen_Prt()
   @ 30,635  BUTTON B8 PARENT Form_1 CAPTION "Load Picture" WIDTH 80 BOLD ONCLICK Picload ()
 
   @ 288,30 LABEL L223 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Art - Aspect Ratio"
   @ 285,170 TEXTBOX V61 PARENT Form_1 WIDTH 35 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 283,209 BUTTON B11 PARENT Form_1 CAPTION "Lock" WIDTH 40 BOLD ONCLICK Ratiocalc()
   @ 285,253 TEXTBOX V64 PARENT Form_1 WIDTH 13 NOTABSTOP READONLY

   @ 316,30 LABEL L222 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Mat - Aspect Ratio"
   @ 344,30 LABEL L227 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Art Area / Mat-WS"
   @ 313,170 TEXTBOX V60 PARENT Form_1 WIDTH 35 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 341,170 TEXTBOX V66 PARENT Form_1 WIDTH 35 NUMERIC RIGHTALIGN NOTABSTOP READONLY

   @ 372,30 LABEL L226 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Avg Border Percent"
   @ 369,170 TEXTBOX V65 PARENT Form_1 WIDTH 35 NUMERIC NOTABSTOP READONLY

   @ 400,30 LABEL L224 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Width Percent"
   @ 397,170 TEXTBOX V62 PARENT Form_1 WIDTH 35 NUMERIC RIGHTALIGN NOTABSTOP READONLY

   @ 428,30 LABEL L225 PARENT Form_1 WIDTH 130 RIGHTALIGN VALUE "Length Percent"
   @ 425,170 TEXTBOX V63 PARENT Form_1 WIDTH 35 NUMERIC RIGHTALIGN NOTABSTOP READONLY

   @ 503,34  LABEL L60 PARENT Form_1 WIDTH 12  VALUE "W" bold
   @ 500,49  TEXTBOX V51 PARENT Form_1 WIDTH 46 NUMERIC
   @ 503,107 LABEL L61 PARENT Form_1 WIDTH 11  VALUE "L" bold
   @ 500,117 TEXTBOX V52 PARENT Form_1 WIDTH 46 NUMERIC
   @ 498,168 BUTTON B12 PARENT Form_1 CAPTION "AR" WIDTH 40 BOLD ONCLICK KAR_Calc()
   @ 501,215 TEXTBOX V53 PARENT Form_1 WIDTH 50 NUMERIC NOTABSTOP READONLY

   @ 534,34 TEXTBOX V80 PARENT Form_1 WIDTH 60 NUMERIC
   @ 532,100 BUTTON  B80 PARENT Form_1 CAPTION "mm-2-In" WIDTH 57 BOLD ONCLICK mm2Id_Calc()
   @ 534,162 TEXTBOX V81 PARENT Form_1 WIDTH 45 NUMERIC NOTABSTOP READONLY
   @ 534,213 TEXTBOX V82 PARENT Form_1 WIDTH 63 NOTABSTOP READONLY 

   @ 569,34 TEXTBOX V50 PARENT Form_1 WIDTH 60
   @ 569,100 BUTTON B9 PARENT Form_1 CAPTION "In-2-mm" WIDTH 60 BOLD ONCLICK Str2mm_Calc()
   @ 569,165 TEXTBOX B15 PARENT Form_1 WIDTH 55 NOTABSTOP READONLY 
   @ 598,34 LABEL L40 PARENT Form_1 WIDTH 250  VALUE "Decimal or Fraction (12.25, 7:1/8, 0:3/8)"

*** Bottom

   @ 510,340 LABEL L41 PARENT Form_1 WIDTH 110 VALUE "Load - Default" bold
   @ 510,462 LABEL L42 PARENT Form_1 WIDTH 110 VALUE "Save - Current" bold
   *
   @ 530,330 BUTTON  B16 PARENT Form_1 CAPTION "A" WIDTH 20 BOLD ONCLICK Print_Fill_A()
   @ 530,355 BUTTON  B17 PARENT Form_1 CAPTION "B" WIDTH 20 BOLD ONCLICK Print_Fill_B()
   @ 530,380 BUTTON  B18 PARENT Form_1 CAPTION "C" WIDTH 20 BOLD ONCLICK Print_Fill_C()
   @ 530,405 BUTTON  B19 PARENT Form_1 CAPTION "D" WIDTH 20 BOLD ONCLICK Print_Fill_D()
   *
   @ 530,455 BUTTON  B20 PARENT Form_1 CAPTION "A" WIDTH 20 BOLD ONCLICK Calc_Save_A()
   @ 530,480 BUTTON  B21 PARENT Form_1 CAPTION "B" WIDTH 20 BOLD ONCLICK Calc_Save_B()
   @ 530,505 BUTTON  B22 PARENT Form_1 CAPTION "C" WIDTH 20 BOLD ONCLICK Calc_Save_C()
   @ 530,530 BUTTON  B23 PARENT Form_1 CAPTION "D" WIDTH 20 BOLD ONCLICK Calc_Save_D()
   *
   @ 530,577 BUTTON  B24 PARENT Form_1 CAPTION "Calculate" WIDTH 70 BOLD ONCLICK Print_Calc()

   @ 565,329 Label   L72 PARENT Form_1 WIDTH 72 VALUE "Aspect  Ratio"
   @ 586,330 TEXTBOX V72 PARENT Form_1 WIDTH 70 NUMERIC 
   @ 565,412 Label   L71 PARENT Form_1 WIDTH 70 VALUE "Target  Ratio"

   @ 586,412 TEXTBOX V71 PARENT Form_1 WIDTH 70 NUMERIC 
   @ 565,494 Label   L73 PARENT Form_1 WIDTH 70 VALUE " Max - Width"
   @ 586,494 TEXTBOX V73 PARENT Form_1 WIDTH 70 NUMERIC 
   @ 565,576 Label   L74 PARENT Form_1 WIDTH 70 VALUE "Max - Length"
   @ 586,576 TEXTBOX V74 PARENT Form_1 WIDTH 70 NUMERIC 
   @ 565,668 Label   L75 PARENT Form_1 WIDTH 45 VALUE "Results" bold

   @ 520,734 Label   L76 PARENT Form_1 WIDTH 60 VALUE "Art  Width"
   @ 520,801 Label   L77 PARENT Form_1 WIDTH 70 VALUE "Art  Length"  

   @ 546,732 TEXTBOX V78 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY
   @ 550,862 Label   L78 PARENT Form_1 WIDTH 24 VALUE "mm"  
   @ 546,798 TEXTBOX V79 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY 
   @ 577,732 TEXTBOX V76 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY 
   @ 581,862 Label   L79 PARENT Form_1 WIDTH 25 VALUE "In"  
   @ 577,798 TEXTBOX V77 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY

*** Right Side

   @ 35,801 Label L999 PARENT Form_1 WIDTH 200 VALUE "mm      In:Frac"

   @ 60,742 LABEL L100 PARENT Form_1 WIDTH 55 VALUE  "Mat-1   A"
   @ 55,796 TEXTBOX V100 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 59,840 Label L1005 PARENT Form_1 WIDTH 65 VALUE ""

   @ 87,742 LABEL L101 PARENT Form_1 WIDTH 55 VALUE  "Mat-1   B"
   @ 82,796 TEXTBOX V101 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 86,840 Label L1015 PARENT Form_1 WIDTH 65 VALUE ""

   @ 114,742 LABEL L102 PARENT Form_1 WIDTH 55 VALUE  "Mat-1   C"
   @ 109,796 TEXTBOX V102 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 113,840 Label L1025 PARENT Form_1 WIDTH 65 VALUE ""

   @ 141,742 LABEL L103 PARENT Form_1 WIDTH 55 VALUE "Mat-1   D"
   @ 136,796 TEXTBOX V103 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 140,840 Label L1035 PARENT Form_1 WIDTH 65 VALUE ""

   @ 176,742 LABEL L104 PARENT Form_1 WIDTH 55 VALUE "Mat-2   A"
   @ 171,796 TEXTBOX V104 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 175,840 Label L1045 PARENT Form_1 WIDTH 65 VALUE ""

   @ 203,742 LABEL L105 PARENT Form_1 WIDTH 55 VALUE "Mat-2   B"
   @ 198,796 TEXTBOX V105 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 202,840 Label L1055 PARENT Form_1 WIDTH 65 VALUE ""

   @ 230,742 LABEL L106 PARENT Form_1 WIDTH 55 VALUE "Mat-2   C"
   @ 225,796 TEXTBOX V106 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 229,840 Label L1065 PARENT Form_1 WIDTH 65 VALUE ""
            
   @ 257,742 LABEL L107 PARENT Form_1 WIDTH 55 VALUE "Mat-2   D"
   @ 252,796 TEXTBOX V107 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 256,840 Label L1075 PARENT Form_1 WIDTH 65 VALUE ""
            
   @ 292,742 LABEL L108 PARENT Form_1 WIDTH 55 VALUE "Mat-3   A"
   @ 287,796 TEXTBOX V108 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 291,840 Label L1085 PARENT Form_1 WIDTH 65 VALUE ""
            
   @ 319,742 LABEL L109 PARENT Form_1 WIDTH 55 VALUE "Mat-3   B"
   @ 314,796 TEXTBOX V109 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 318,840 Label L1095 PARENT Form_1 WIDTH 65 VALUE ""
            
   @ 346,742 LABEL L110 PARENT Form_1 WIDTH 55 VALUE "Mat-3   C"
   @ 341,796 TEXTBOX V110 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 345,840 Label L1105 PARENT Form_1 WIDTH 65 VALUE ""
            
   @ 373,742 LABEL L111 PARENT Form_1 WIDTH 55 VALUE "Mat-3   D"
   @ 368,796 TEXTBOX V111 PARENT Form_1 WIDTH 32 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 372,840 Label L1115 PARENT Form_1 WIDTH 65 VALUE ""

   @ 403,746 Label L210 PARENT Form_1 WIDTH 135 VALUE "Frame Lip  (mm)" Bold
   @ 424,752 TEXTBOX V210 PARENT Form_1 WIDTH 40 NUMERIC 
   @ 422,796 BUTTON B210 PARENT Form_1 CAPTION "Calc" WIDTH 40 BOLD ONCLICK Frame_Lip() 
 
   @ 457,732 TEXTBOX V213 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY
   @ 457,798 TEXTBOX V214 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY
   @ 462,862 Label L213 PARENT Form_1 WIDTH 22 VALUE "mm"

   @ 486,732 TEXTBOX V211 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY
   @ 486,798 TEXTBOX V212 PARENT Form_1 WIDTH 60 NUMERIC NOTABSTOP READONLY
   @ 490,862 Label L211 PARENT Form_1 WIDTH 22 VALUE "In"

RETURN NIL

************************************************************************* 

Function Frame_Lip()
 Local Photo_Width, Photo_Length, Mat_Length, Mat_Width, Frame_Lip, Mat_Overlap, AR, WS, X
 Local AMat_Width, AMat_Length, AMat_Area, APhoto_Width, APhoto_Length, APhoto_Area, AWS, Alip
 Local BPhoto_Width, BPhoto_Length

 Mat_Width = 0
 Mat_Length = 0
 Photo_Width = 0
 Photo_Length = 0
 Frame_Lip = 0
 Mat_Overlap = 0
 AR = 0
 WS = 0
 AMat_Width = 0 
 AMat_Length = 0
 AMat_Area = 0 
 APhoto_Width = 0
 APhoto_Length = 0
 APhoto_Area = 0
 AWS = 0
 Alip = 0

 Matcalc()

 If Form_1.V1.value>0 .and. Form_1.V2.value>0 .and. Form_1.V3.value>0 .and. Form_1.V4.value>0
 If Form_1.V5.value > -50 .and. Form_1.V5.value < 50 .and. Form_1.V210.value >= 0 

 Mat_Width := Form_1.V1.value
 Mat_Length := Form_1.V2.value
 Photo_Width := Form_1.V3.value
 Photo_Length := Form_1.V4.value
 Mat_Overlap := Form_1.V5.value
 Frame_Lip := Form_1.V210.value

 If Mat_Width > 60
   Mat_Width = (Mat_Width/25.4)
 endif
 If Mat_Length > 60
   Mat_Length = (Mat_Length/25.4)
 endif
 If Photo_Width > 60
   Photo_Width = (Photo_Width/25.4)
 endif
 If Photo_Length > 60
   Photo_Length = (Photo_Length/25.4)
 endif
 If Mat_Overlap < 0
 Mat_Overlap := 0
 endif

 AR = Photo_Length/Photo_Width
 WS = ((Mat_Width*Mat_Length)-(Photo_Width*Photo_Length))/(Photo_Width*Photo_Length)
 Alip = (2*(Frame_Lip/25.4))
  
 AMat_Width = Mat_Width-(Alip) 
 AMat_Length = Mat_Length-(Alip)  
 AMat_Area = (AMat_Width*AMat_Length)
 APhoto_Width = Photo_Width - (2*(Mat_Overlap/25.4))
 APhoto_Length = Photo_Length - (2*(Mat_Overlap/25.4))
 APhoto_Area = (APhoto_Width*APhoto_Length)
 AWS = (AMat_Area-APhoto_Area)/APhoto_Area
  
 If AWS > WS 
 x=0 
 Do while AWS > WS
 APhoto_Width = APhoto_Width + x 
 APhoto_Length = APhoto_Length + (x*AR) 
 APhoto_Area = (APhoto_Width*APhoto_Length)
 AWS = ((AMat_Area-APhoto_Area)/APhoto_Area)       
 x=x+0.00001
 enddo
 endif
  
 If AWS < WS 
 x=0 
 Do while AWS < WS
 APhoto_Width = APhoto_Width + x 
 APhoto_Length = APhoto_Length + (x*AR) 
 APhoto_Area = (APhoto_Width*APhoto_Length)
 AWS = ((AMat_Area-APhoto_Area)/APhoto_Area)       
 x=x-0.00001
 enddo
 endif
  
 BPhoto_Width = round(Aphoto_Width+(2*(Mat_Overlap/25.4)),2)
 *  BPhoto_Length = Round((BPhoto_Width*AR),2)
 BPhoto_Length = round(Aphoto_Length+(2*(Mat_Overlap/25.4)),2)
  
 if ABS((BPhoto_Width-Photo_Width)) <= 0.01 
 BPhoto_Width = Photo_Width
 BPhoto_Length = Photo_Length
 endif

 Form_1.V211.value := BPhoto_Width
 Form_1.V212.value := BPhoto_Length
 Form_1.V213.value := round((BPhoto_Width*25.4),0)
 Form_1.V214.value := round((BPhoto_Length*25.4),0)

 endif
 endif
*
RETURN NIL

************************************************************************* 

Function mm2Id_Calc()
if Form_1.V80.value > 0 .and. Form_1.V80.value <= 100000
mm2Id_mm := Form_1.V80.value
mm2Id_Id := (mm2Id_mm/25.4)
Form_1.V81.value := round(mm2Id_Id,2)
Kstrmm := round(mm2Id_Id,2) * 25.4
Form_1.V82.value := mm2fract(Kstrmm)
else
Form_1.V81.value := 0
Form_1.V82.value := " "
endif
RETURN NIL

*************************************************************************

Function Str2mm_Calc()
calcin := ltrim(Form_1.V50.value)
Calcout:= Str2mm(calcin)
Form_1.B15.value := Calcout
RETURN NIL

*************************************************************************

Function KAR_Calc()
kar_w = Form_1.V51.value
kar_l = Form_1.V52.value
If kar_w > 0 .and. kar_l > 0 .and. kar_l >= kar_w
kar_A = (kar_l/kar_w)
Form_1.V53.value := kar_A
else
Form_1.V53.value := 0
endif
RETURN NIL

*************************************************************************

function Calc_Save_A()
  If Form_1.V71.value > 0 .and. Form_1.V72.value > 0 .and. Form_1.V73.value > 0 .and. Form_1.V74.value > 0
    Memowrit("Default_A.txt", str(Form_1.V71.value,8,3)+str(Form_1.V73.value,8,0)+str(Form_1.V74.value,8,0))
  endif
RETURN NIL

*************************************************************************

function Calc_Save_B()
  If Form_1.V71.value > 0 .and. Form_1.V72.value > 0 .and. Form_1.V73.value > 0 .and. Form_1.V74.value > 0
    Memowrit("Default_B.txt", str(Form_1.V71.value,8,3)+str(Form_1.V73.value,8,0)+str(Form_1.V74.value,8,0))
  endif
RETURN NIL

*************************************************************************

function Calc_Save_C()
  If Form_1.V71.value > 0 .and. Form_1.V72.value > 0 .and. Form_1.V73.value > 0 .and. Form_1.V74.value > 0
    Memowrit("Default_C.txt", str(Form_1.V71.value,8,3)+str(Form_1.V73.value,8,0)+str(Form_1.V74.value,8,0))
  endif
RETURN NIL

*************************************************************************

function Calc_Save_D()
  If Form_1.V71.value > 0 .and. Form_1.V72.value > 0 .and. Form_1.V73.value > 0 .and. Form_1.V74.value > 0
    Memowrit("Default_D.txt", str(Form_1.V71.value,8,3)+str(Form_1.V73.value,8,0)+str(Form_1.V74.value,8,0))
  endif
RETURN NIL

*************************************************************************

Function Print_Fill_A()
Local tstring

   TargetMW = Form_1.V1.value
   TargetML = Form_1.V2.value

 If TargetMW > 0 .and. TargetML > 0 

   if Form_1.V61.value > 0
   TargetAR := Form_1.V61.value
   else
   TargetAR = 1.5
   endif

   If file ("Default_A.txt")
   tstring := memoread("Default_A.txt")
   TargetWS := val(substr(tstring,1,8)) 
   TargetWP := val(substr(tstring,9,8)) 
   TargetLP := val(substr(tstring,17,8))
   else
   TargetWS = 1.62
   TargetWP = 85
   TargetLP = 85
   endif

   Form_1.V71.value := TargetWS
   Form_1.V72.value := TargetAR
   Form_1.V73.value := TargetWP
   Form_1.V74.value := TargetLP

 endif

RETURN NIL

*************************************************************************

Function Print_Fill_B()
Local tstring

   TargetMW = Form_1.V1.value
   TargetML = Form_1.V2.value

 If TargetMW > 0 .and. TargetML > 0 

   if Form_1.V61.value > 0
   TargetAR := Form_1.V61.value
   else
   TargetAR = 1.5
   endif

   If file ("Default_B.txt")
   tstring := memoread("Default_B.txt")
   TargetWS := val(substr(tstring,1,8)) 
   TargetWP := val(substr(tstring,9,8)) 
   TargetLP := val(substr(tstring,17,8))
   else
   TargetWS = 1.62
   TargetWP = 85
   TargetLP = 85
   endif

   Form_1.V71.value := TargetWS
   Form_1.V72.value := TargetAR
   Form_1.V73.value := TargetWP
   Form_1.V74.value := TargetLP

 endif

RETURN NIL

*************************************************************************

Function Print_Fill_C()
Local tstring

   TargetMW = Form_1.V1.value
   TargetML = Form_1.V2.value

 If TargetMW > 0 .and. TargetML > 0 

   if Form_1.V61.value > 0
   TargetAR := Form_1.V61.value
   else
   TargetAR = 1.5
   endif

   If file ("Default_C.txt")
   tstring := memoread("Default_C.txt")
   TargetWS := val(substr(tstring,1,8)) 
   TargetWP := val(substr(tstring,9,8)) 
   TargetLP := val(substr(tstring,17,8))
   else
   TargetWS = 1.62
   TargetWP = 85
   TargetLP = 85
   endif

   Form_1.V71.value := TargetWS
   Form_1.V72.value := TargetAR
   Form_1.V73.value := TargetWP
   Form_1.V74.value := TargetLP

 endif

RETURN NIL

*************************************************************************

Function Print_Fill_D()
Local tstring

   TargetMW = Form_1.V1.value
   TargetML = Form_1.V2.value

 If TargetMW > 0 .and. TargetML > 0 

   if Form_1.V61.value > 0
   TargetAR := Form_1.V61.value
   else
   TargetAR = 1.5
   endif

   If file ("Default_D.txt")
   tstring := memoread("Default_D.txt")
   TargetWS := val(substr(tstring,1,8)) 
   TargetWP := val(substr(tstring,9,8)) 
   TargetLP := val(substr(tstring,17,8))
   else
   TargetWS = 1.62
   TargetWP = 85
   TargetLP = 85
   endif

   Form_1.V71.value := TargetWS
   Form_1.V72.value := TargetAR
   Form_1.V73.value := TargetWP
   Form_1.V74.value := TargetLP

 endif

RETURN NIL

*************************************************************************

Function Print_Calc()
Local SMat, Photo_Width, Photo_Length, SPhoto, Ratio, Aspect_Ratio, Mat_Length, Mat_Width

   TargetMW = Form_1.V1.value
   TargetML = Form_1.V2.value

   If TargetMW > 60
    TargetMW = (TargetMW/25.4)
   endif
   If TargetML > 60
    TargetML = (TargetML/25.4)
   endif
*
   If TargetMW > 0 .and. TargetMW <= 60 .and. TargetML > 0 .and. TargetML <= 60
   TargetWS = Form_1.V71.value
   TargetAR = Form_1.V72.value
   TargetWP = Form_1.V73.value
   TargetLP = Form_1.V74.value
*  
   if TargetWS > 0 .and. TargetWS < 9 .and. TargetAR > 0 .and. TargetAR < 7
   if TargetWP > 25  .and. TargetWP < 99 .and. TargetLP > 25  .and. TargetLP < 99
 
   SMat = TargetMW * TargetML
   Photo_Width  = 1
   Photo_Length = Photo_Width * TargetAR
   SPhoto = Photo_Width * Photo_Length
   Ratio = SPhoto/(SMat-Sphoto)
 
   do while Ratio <= TargetWS
   Photo_Width = Photo_Width + 0.031250
   Photo_Length = Photo_Width * TargetAR
   SPhoto  = Photo_Width * Photo_Length
   Ratio = SPhoto/(SMat-Sphoto)
   enddo

   If Photo_Length > TargetML * (TargetLP/100)
   Photo_Length = TargetML * (TargetLP/100)
   Photo_Width = Photo_Length / TargetAR
   endif
 
   If Photo_Width > TargetMW * (TargetWP/100) 
   Photo_Width = TargetMW * (TargetWP/100)
   Photo_Length = Photo_Width * TargetAR
   endif

   Form_1.V76.value := Round(Photo_Width,2)
   Form_1.V77.value := Round(Photo_Length,2)
   Form_1.V78.value := Round((Photo_Width*25.4),0)
   Form_1.V79.value := Round((Photo_Length*25.4),0)

   endif
   endif
   endif
*
RETURN NIL

*************************************************************************

  FUNCTION Ratiocalc()
   if Form_1.V61.value > 0
   if KJE = 0
    KJE = 1
    ark := Arx
    Form_1.V64.value := "X"
    picwidth = piclength/ark
    Form_1.V3.value := picwidth
    else
    KJE = 0
    Form_1.V64.value := " "
   endif
  endif
  RETURN NIL

*************************************************************************

FUNCTION Str2mm(SF)
LOCAL X, C, L, cInch, cfract, D, DD, ctop, cbottom, ntop
Local mm, ninch, nmetric, cmetric, ndecimal, nbottom, nfract
*
If SF <> " " 
  X=alltrim(SF)
  L=len(X)
	If ":" $ X
	  C = at(":",X)
		if c > 1
		  cInch=substr(X,1,(C-1))
		  cFract=substr(X,(C+1),(L-C))
	  	  D=at("/",cFract)
		  DD=len(cFract)
		  ctop=substr(cFract,1,(D-1))
		  cbottom=substr(cFract,(D+1),(DD-D))
		  ntop=val(ctop)
		  nbottom=val(cbottom)
		  NFract=(ntop/nbottom)
		  ninch=val(cinch)
		  mm=25.4
		  nmetric=(ninch*mm)+(nfract*mm)
			if nmetric >= 51
			  cmetric=str(nmetric,6,0)
			else
			  cmetric=str(nmetric,6,1)
			endif
		endif
	else
		  mm=25.4
          ndecimal=val(x)*mm
			if ndecimal >= 51
			  cmetric=str(ndecimal,6,0)
			else
			  cmetric=str(ndecimal,6,1)
			endif
	endif
Endif
RETURN cmetric

************************************************************************************************

* License window
FUNCTION d_kmat_lic ()
   DEFINE WINDOW kmat_lic AT 50,50 WIDTH 524 HEIGHT 417 TITLE 'License' NOSHOW NOAUTORELEASE

       DEFINE BUTTON Button_1
       ROW	340
       COL	211
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,184 LABEL L0  PARENT kmat_lic WIDTH 450 VALUE "  Kmat -- Matboard Calculator"
       @ 30,184 LABEL L1  PARENT kmat_lic WIDTH 450 VALUE "     Version 9.00 -- (6.2024)"
       @ 45,184 LABEL L2  PARENT kmat_lic WIDTH 450 VALUE "Copyrite (C) 2024:  Kurt Ebert"
       @ 60,65  LABEL L3  PARENT kmat_lic WIDTH 450 VALUE ""
       @ 75,65  LABEL L4  PARENT kmat_lic WIDTH 450 VALUE "This program is free software: you can redistribute it and/or modify" 
       @ 90,65  LABEL L5  PARENT kmat_lic WIDTH 450 VALUE "it under the terms of the GNU General Public License as published by" 
       @ 105,65 LABEL L6  PARENT kmat_lic WIDTH 450 VALUE "the Free Software Foundation, version 3 of the license."              
       @ 120,65 LABEL L7  PARENT kmat_lic WIDTH 450 VALUE ""                                                                     
       @ 135,65 LABEL L8  PARENT kmat_lic WIDTH 450 VALUE "This program is distributed in the hope that it will be useful,"      
       @ 150,65 LABEL L9  PARENT kmat_lic WIDTH 450 VALUE "but WITHOUT ANY WARRANTY; without even the implied warranty of"       
       @ 165,65 LABEL L10 PARENT kmat_lic WIDTH 450 VALUE "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See"             
       @ 180,65 LABEL L11 PARENT kmat_lic WIDTH 450 VALUE "the GNU General Public License for more details."                     
       @ 195,65 LABEL L12 PARENT kmat_lic WIDTH 450 VALUE ""                                                                     
       @ 210,65 LABEL L13 PARENT kmat_lic WIDTH 450 VALUE "You should have received a copy of the GNU General Public License"    
       @ 225,65 LABEL L14 PARENT kmat_lic WIDTH 450 VALUE "along with this program. If not, see {<http://www.gnu.org/licenses/>}"
       @ 240,65 LABEL L15 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 255,210 LABEL L16 PARENT kmat_lic WIDTH 450 VALUE "Contact Information"
       @ 280,179 hyperlink ip1 width 300 value "Email: kurt@kurtebertphoto.com" address "kurt@kurtebertphoto.com" handcursor
       @ 294,260 LABEL L17 PARENT kmat_lic WIDTH 25 VALUE "~"
       @ 306,184 hyperlink ip2 width 300 value "www.kurtebertphoto.com/kmat" address "http://kurtebertphoto.com/kmat" handcursor
   END WINDOW
RETURN NIL

************************************************************************************************

* Help Window
FUNCTION d_kmat_help ()
   DEFINE WINDOW kmat_help AT 50,50 WIDTH 524 HEIGHT 660 TITLE 'Help Part 1' NOSHOW NOAUTORELEASE
 
       DEFINE BUTTON Button_2
       ROW	570
       COL	211
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,65  LABEL H0  PARENT kmat_help WIDTH 500 VALUE "First 4 fields are mandatory to cut a matboard"
       @ 30,65  LABEL H1  PARENT kmat_help WIDTH 500 VALUE "First 4 fields take either inch or mm values"
       @ 45,65  LABEL H2  PARENT kmat_help WIDTH 500 VALUE "Length field must be equal or larger than width"
       @ 60,65  LABEL H3  PARENT kmat_help WIDTH 500 VALUE "Numbers less than 60 are calculated as inches"
       @ 75,65  LABEL H4  PARENT kmat_help WIDTH 500 VALUE "Decimal numbers allowed (14.75)"
       @ 90,65  LABEL H5  PARENT kmat_help WIDTH 500 VALUE "Art size needs to be less than mat size"
       @ 105,65 LABEL H6  PARENT kmat_help WIDTH 500 VALUE " " 
       @ 120,65 LABEL H7  PARENT kmat_help WIDTH 500 VALUE "Mat Overlap is in mm, and can be positive or negative " 
       @ 135,65 LABEL H8  PARENT kmat_help WIDTH 500 VALUE "Mat set backs are positive only and in mm" 
       @ 150,65 LABEL H9  PARENT kmat_help WIDTH 500 VALUE " " 
       @ 165,65 LABEL H10 PARENT kmat_help WIDTH 500 VALUE "Calculated offset values are displayed just right of offset fields" 
       @ 180,65 LABEL H11 PARENT kmat_help WIDTH 500 VALUE "Use correct offset field for project orientation"    
       @ 195,65 LABEL H12 PARENT kmat_help WIDTH 500 VALUE "Blank / Zero offsets = project centered and defaults to landscape"                       
       @ 210,65 LABEL H13 PARENT kmat_help WIDTH 500 VALUE "Either offset field > 0 will rotate project automatically " 
       @ 225,65 LABEL H14 PARENT kmat_help WIDTH 500 VALUE "Entering a very small number in portrait offset will force rotation,"
       @ 240,65 LABEL H15 PARENT kmat_help WIDTH 500 VALUE "without changing mat cuts and keep program in auto rotation"
       @ 255,65 LABEL H16 PARENT kmat_help WIDTH 500 VALUE "Example: 0.1 in portrate offset"                   
       @ 270,65 LABEL H17 PARENT kmat_help WIDTH 500 VALUE "If you use the Orientation Button you leave auto mode"
       @ 285,65 LABEL H18 PARENT kmat_help WIDTH 500 VALUE " "
       @ 300,65 LABEL H19 PARENT kmat_help WIDTH 500 VALUE "Buttons"                                                             
       @ 315,65 LABEL H20 PARENT kmat_help WIDTH 500 VALUE "Calculate = Re-do all math after a change and save for reporting"                                                                              
       @ 330,65 LABEL H21 PARENT kmat_help WIDTH 500 VALUE "Orientation = Needed when using both offsets at once"                                          
       @ 345,65 LABEL H22 PARENT kmat_help WIDTH 500 VALUE "Hide = Replace picture with dark grey, prefered by some to visulize"
       @ 360,65 LABEL H23 PARENT kmat_help WIDTH 500 VALUE "Pdf / Txt / Screen = Reports as pdf, text file or screen capture"                           
       @ 375,65 LABEL H24 PARENT kmat_help WIDTH 500 VALUE "Load Picture = View a (Jpg) of you own in the program"                                               
       @ 390,65 LABEL H25 PARENT kmat_help WIDTH 500 VALUE "Note - Any re-calc and program will default to normal pictures"                                    
       @ 405,65 LABEL H26 PARENT kmat_help WIDTH 500 VALUE "Need to be jpg and not masive in size "                                                          
       @ 420,65 LABEL H27 PARENT kmat_help WIDTH 500 VALUE ""                                                                                                                         
       @ 435,65 LABEL H28 PARENT kmat_help WIDTH 500 VALUE "         For Mat Cutting"                                                                                                                                                       
       @ 450,65 LABEL H29 PARENT kmat_help WIDTH 500 VALUE " --------------------------------"                                                                                                                                                  
       @ 465,65 LABEL H30 PARENT kmat_help WIDTH 500 VALUE  "Place matboard with it's length,"                                                                                                                                            
       @ 480,65 LABEL H31 PARENT kmat_help WIDTH 500 VALUE  "longer side (Horizontal)"             
       @ 495,65 LABEL H32 PARENT kmat_help WIDTH 500 VALUE  ""                                           
       @ 510,65 LABEL H33 PARENT kmat_help WIDTH 500 VALUE "Measure, mark, cut from the back side"       
       @ 525,65 LABEL H34 PARENT kmat_help WIDTH 500 VALUE "A=Top, B=Bottom, C=Left, D=Right"       
       @ 540,65 LABEL H35 PARENT kmat_help WIDTH 500 VALUE ""       
 
   END WINDOW
RETURN NIL

************************************************************************************************

* Extra features window
FUNCTION d_kmat_extra ()
    DEFINE WINDOW kmat_extra AT 50,50 WIDTH 575 HEIGHT 525 TITLE 'Help Part 2' NOSHOW NOAUTORELEASE
 
       DEFINE BUTTON Button_3
       ROW	420
       COL	222
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,65  LABEL HA0  PARENT kmat_help WIDTH 450 VALUE "" 
       @ 30,65  LABEL HA1  PARENT kmat_help WIDTH 450 VALUE "It is possible for you to load your own pictures" 
       @ 45,65  LABEL HA2  PARENT kmat_help WIDTH 450 VALUE "as the programs default set"           
       @ 60,65  LABEL HA3  PARENT kmat_help WIDTH 450 VALUE "Please email me for instructions"                      
       @ 75,65  LABEL HA4  PARENT kmat_help WIDTH 450 VALUE ""
       @ 90,65  LABEL HA5  PARENT kmat_help WIDTH 450 VALUE "The Decimal-Fraction Calculator"           
       @ 105,65 LABEL HA6  PARENT kmat_help WIDTH 450 VALUE "works independent from other calculations" 
       @ 120,65 LABEL HA7  PARENT kmat_help WIDTH 450 VALUE ""                                           
       @ 135,65 LABEL HA8  PARENT kmat_help WIDTH 450 VALUE "Decimal Examples: 12.75, 11, 3.5, 7.333"   
       @ 150,65 LABEL HA9  PARENT kmat_help WIDTH 450 VALUE "Fraction Examples: Need a colon { : }"     
       @ 165,65 LABEL HA10 PARENT kmat_help WIDTH 450 VALUE 'Inch, a ":" then the Numerator/Denominator'
       @ 180,65 LABEL HA11 PARENT kmat_help WIDTH 450 VALUE "Inch:Numerator/Denominator"                
       @ 195,65 LABEL HA12 PARENT kmat_help WIDTH 450 VALUE "10:3/8, 11:9/16, 0:3/16, 0:7/8"            
       @ 210,65 LABEL HA13 PARENT kmat_help WIDTH 450 VALUE ""                                          
       @ 225,65 LABEL HA14 PARENT kmat_help WIDTH 450 VALUE "The print size calculator uses first two fields"
       @ 240,65 LABEL HA15 PARENT kmat_help WIDTH 450 VALUE "mat-width and mat-length for all calculations"
       @ 255,65 LABEL HA16 PARENT kmat_help WIDTH 450 VALUE ""
       @ 270,65 LABEL HA17 PARENT kmat_help WIDTH 450 VALUE "The overlap:frame-lip calculator loads the"
       @ 285,65 LABEL HA18 PARENT kmat_help WIDTH 450 VALUE "mat overlap value from field 5 and the frame lip field"
       @ 300,65 LABEL HA19 PARENT kmat_help WIDTH 450 VALUE "to calculate a corrected art/photo size"
       @ 315,65 LABEL HA20 PARENT kmat_help WIDTH 450 VALUE ""
       @ 330,65 LABEL HA21 PARENT kmat_help WIDTH 450 VALUE "This and the bottom weighting should be the last" 
       @ 345,65 LABEL HA22 PARENT kmat_help WIDTH 450 VALUE "things you change before calculation and "   
       @ 360,65 LABEL HA23 PARENT kmat_help WIDTH 450 VALUE "printing out report"                          
       @ 375,65 LABEL HA24 PARENT kmat_help WIDTH 450 VALUE ""
       @ 390,65 LABEL HA25 PARENT kmat_help WIDTH 450 VALUE ""
 
      END WINDOW                                                                                             
RETURN NIL

************************************************************************************************

* define main menu
FUNCTION d_main_menu ()
   DEFINE MAIN MENU OF Form_1
     DEFINE POPUP "File" 
         MENUITEM "Exit" ACTION Form_1.Release
      END POPUP 
      DEFINE POPUP "About" 
         MENUITEM "License" ACTION kmat_lic.Show
      END POPUP 
      DEFINE POPUP "Help" 
         MENUITEM "Help 1" ACTION kmat_help.Show
         MENUITEM "Help 2" ACTION kmat_extra.Show
      END POPUP 
   END MENU
RETURN NIL

************************************************************************************************

* define photo 
FUNCTION d_Image_photo ()
   DEFINE IMAGE Img1
   PARENT Form_1
   ROW 80
   COL 310
   STRETCH .t.
   VISIBLE .f.
   END IMAGE
RETURN NIL

************************************************************************************************

  * Screen Capture Report
   FUNCTION Screen_prt()
   *
   *  PRINTWINDOW ( cWindowName , lPreview , ldialog , nRow , nCol , nWidth , nHeight ) ***
   *  SAVEWINDOW  ( cWindowName , cFileName , nRow , nCol , nWidth , nHeight )          ***
   *
   if Kcalc > 0 
   * SAVEWINDOW ("Form_1", "Kmat.bmp")
   PRINTWINDOW ("Form_1", .t., .t.)
   endif
   RETURN NIL

************************************************************************************************

  * Manual override of project orentation
   FUNCTION Flipmat()
      if Kcalc > 0
         HVM := 1
            if HV=0
               HV:=1
            else
               HV:=0
            endif
         DRAW RECTANGLE IN WINDOW Form_1 AT x-20,y-20 TO x+392+20,y+392+20 PENCOLOR {212,208,200} PENWIDTH 0 FILLCOLOR {212,208,200}
         Form_1.Restore
         Matcalc()
      endif
   Return Nil

**********************************************************************************************
 
  * Check value of fields to auto rotate project
   Function Chk_Port()
    If HVM = 0
      if Form_1.V9.value <> 0 .and. Form_1.V8.value = 0
         HV:=1
       else
         HV:=0
      endif
    Endif
    Form_1.Restore
   Return Nil

**********************************************************************************************

  * Flip to load or hide photo in project
   Function Want_photo()
   if Kcalc > 0
     If Kphoto = 0
         Kphoto := 1
         Loadpic ()
      else
         CleanSlate ()
     Endif
   endif
   Return Nil

*********************************************************************************************

* Hide, Release and re-define image to clear for new image loading
   Function CleanSlate ()
   Form_1.Img1.Hide
   Form_1.img1.Release
   *
   DEFINE IMAGE Img1
   PARENT Form_1
   ROW 80
   COL 310
   STRETCH .t.
   VISIBLE .f.
   END IMAGE
   *
   RETURN NIL 

*********************************************************************************************

* paint landscape picture
   Function Landscape ()
      Form_1.img1.row := (x2+1)
      Form_1.img1.col := (y2+1)
      Form_1.img1.width := ((yy2-1)-(y2+1))
      Form_1.img1.height:= ((xx2-1)-(x2+1))
      Form_1.Img1.Show
   Return Nil

*********************************************************************************************

* paint portrait picture
   Function Portrait ()
      Form_1.img1.row := (x2p+1)
      Form_1.img1.col := (y2p+1)
      Form_1.img1.width := ((yy2p-1)-(y2p+1))
      Form_1.img1.height:= ((xx2p-1)-(x2p+1))
      Form_1.Img1.Show
   Return Nil

**********************************************************************************************

* load photograph with correct aspect-ratio and orientation for project picture painting
   FUNCTION loadpic()
    if Kcalc = 1
     if Kphoto = 1
      if Rpics = 1
        CleanSlate ()
         if HV = 0
            if AR >= 100 .and. AR < 112
               Form_1.img1.picture := "Pictures/H100.jpg"
            endif
            if AR >= 112 .and. AR < 129
               Form_1.img1.picture := "Pictures/H125.jpg"
            endif
            if AR >= 129 .and. AR < 136
               Form_1.img1.picture := "Pictures/H133.jpg"
            endif
            if AR >= 136 .and. AR < 145
               Form_1.img1.picture := "Pictures/H140.jpg"
            endif
            if AR >= 145 .and. AR < 156
               Form_1.img1.picture := "Pictures/H150.jpg"
            endif
            if AR >= 156 .and. AR < 170
               Form_1.img1.picture := "Pictures/H166.jpg"
            endif
            if AR >= 170 .and. AR < 185
               Form_1.img1.picture := "Pictures/H175.jpg"
            endif
            if AR >= 185 .and. AR < 225
               Form_1.img1.picture := "Pictures/H200.jpg"
            endif
            if AR >= 225 
               Form_1.img1.picture := "Pictures/H300.jpg"
            endif
            Landscape ()
         else
            if AR >= 100 .and. AR < 112
               Form_1.img1.picture := "Pictures/H100.jpg"
            endif
            if AR >= 112 .and. AR < 129
               Form_1.img1.picture := "Pictures/P125.jpg"
            endif
            if AR >= 129 .and. AR < 136
               Form_1.img1.picture := "Pictures/P133.jpg"
            endif
            if AR >= 136 .and. AR < 145
               Form_1.img1.picture := "Pictures/P140.jpg"
            endif
            if AR >= 145 .and. AR < 156
               Form_1.img1.picture := "Pictures/P150.jpg"
            endif
            if AR >= 156 .and. AR < 170
               Form_1.img1.picture := "Pictures/P166.jpg"
            endif
            if AR >= 170 .and. AR < 185
               Form_1.img1.picture := "Pictures/P175.jpg"
            endif
            if AR >= 185 .and. AR < 225
               Form_1.img1.picture := "Pictures/P200.jpg"
            endif
            if AR >= 225
               Form_1.img1.picture := "Pictures/P300.jpg"
            endif
            Portrait ()
         endif
      endif
     endif
    endif
   RETURN NIL

**********************************************************************************************

* Check to see if all pictures are avaliable
   FUNCTION R_pics ()
   if file ("Pictures/H100.jpg") .and. file ("Pictures/P125.jpg") .and.file ("Pictures/P133.jpg") .and. file ("Pictures/P140.jpg") .and. file ("Pictures/P150.jpg") .and. file ("Pictures/P166.jpg") .and. file ("Pictures/P175.jpg") .and. file ("Pictures/P200.jpg");
      .and. file ("Pictures/P300.jpg") .and. file ("Pictures/H125.jpg") .and. file ("Pictures/H133.jpg") .and. file ("Pictures/H140.jpg") .and. file ("Pictures/H150.jpg") .and. file ("Pictures/H166.jpg") .and. file ("Pictures/H175.jpg") .and. file ("Pictures/H200.jpg");
      .and. file ("Pictures/H300.jpg") 
      Rpics := 1
   else
      Rpics := 0
   endif
   RETURN NIL

**********************************************************************************************

  * Txt Report
   FUNCTION Txtprt()
   local padx, ccc
   padx := 6
   Matcalc()
   *
   if Kcalc > 0
   set alternate to "Kmat.txt"
   set alternate on
   ?
   ?
   if len(ltrim(trim(Kname))) > 0
      pady := (75-len(ltrim(trim(Kname))))/2
   ? space(pady), ltrim(trim(Kname))
   else
   ?
   endif
   ? space(5), "_____________________________________________________________"
   ? space(36),"mm",space(3),"Inch:Frac"
   ?
   ? space(10),  "       Matboard Width :", space(1), alltrim(str(round(matw,0))), space(padx-len(alltrim(str(round(matw,0))))), mm2fract(round(matw,0))
   ? space(10),  "      Matboard Length :", space(1), alltrim(str(round(matl,0))), space(padx-len(alltrim(str(round(matl,0))))),  mm2fract(round(matl,0))
   ?  
   ? space(10),  "      Art-Photo Width :", space(1),  alltrim(str(round(picw,0))), space(padx-len(alltrim(str(round(picw,0))))), mm2fract(round(picw,0))
   ? space(10),  "     Art-Photo Length :", space(1),  alltrim(str(round(picl,0))), space(padx-len(alltrim(str(round(picl,0))))), mm2fract(round(picl,0))
   ?

   If overlap = 0.1
   ? space(10),  "     Base Mat Overlap :", space(1),"0", space(padx-len(alltrim(str(round(overlap,1))))), mm2fract(overlap)
   else 
   ? space(10),  "     Base Mat Overlap :", space(1), alltrim(str(round(overlap,1))), space(padx-len(alltrim(str(round(overlap,1))))), mm2fract(overlap) 
   endif

   *
   if m12 <> 0 
   ? space(10),  "         Mat1 to Mat2 :", space(1), alltrim(str(round(m12,0))), space(padx-len(alltrim(str(round(m12,0))))), mm2fract(m12)  
   else
   ? space(10),  "         Mat1 to Mat2 :", space(1),""
   endif  
   *
   if m23 <> 0   
   ? space(10),  "         Mat2 to Mat3 :", space(1), alltrim(str(round(m23,0))), space(padx-len(alltrim(str(round(m23,0))))), mm2fract(m23)      
   else  
   ? space(10),  "         Mat2 to Mat3 :", space(1), ""
   endif
   ?
   if offw <> 0
   ? space(10),  "   Photo Width Offset :", space(1), alltrim(str(round(offw,0))), space(padx-len(alltrim(str(round(offw,0))))), mm2fract(offw) 
   else
   ? space(10),  "   Photo Width Offset :", space(1), ""
   endif
   if offl <> 0    
   ? space(10),  "  Photo Length Offset :", space(1), alltrim(str(round(offl,0))), space(padx-len(alltrim(str(round(offl,0))))), mm2fract(offl)     
   else
   ? space(10),  "  Photo Length Offset :", space(1), ""
   endif
   ? 
   ? space(10),  " Width Optical Center :", space(1),  alltrim(str(round(t3,0))) , space(padx-len(alltrim(str(round(t3,0))))), mm2fract(t3)
   ? space(10),  "Length Optical Center :", space(1),  alltrim(str(round(u3,0))) , space(padx-len(alltrim(str(round(u3,0))))), mm2fract(u3)
   ?
   ?
   ?
   ?
   ? space(30), "Matboard Cuts"
   ? space(6), "_____________________________________________________________"
   ? space(23),"mm",space(2),"Decimal",space(2),"Inch:16th",space(2),"Inch:Frac"
   ?
     txtpad=5-len(ltrim(str(Round(W3,0))))
   ? space(10),  "Mat-1  A :", space(1), substr(ltrim(str(Round(W3,0))),1,5), space(txtpad), ltrim(str(round((w3/cm),2))), space(3), mm2sixteen(w3),	space(2), mm2fract(W3)
     txtpad=5-len(ltrim(str(Round(W4,0))))
   ? space(10),  "Mat-1  B :", space(1), substr(ltrim(str(Round(W4,0))),1,5), space(txtpad), ltrim(str(round((w4/cm),2))), space(3), mm2sixteen(w4),	space(2), mm2fract(W4)
     txtpad=5-len(ltrim(str(Round(l3,0))))
   ? space(10),  "Mat-1  C :", space(1), substr(ltrim(str(round(l3,0))),1,5), space(txtpad), ltrim(str(round((l3/cm),2))), space(3), mm2sixteen(L3),	space(2), mm2fract(L3)
     txtpad=5-len(ltrim(str(Round(l4,0))))
   ? space(10),  "Mat-1  D :", space(1), substr(ltrim(str(round(l4,0))),1,5), space(txtpad), ltrim(str(round((l4/cm),2))), space(3), mm2sixteen(L4),	space(2), mm2fract(L4)
   
   if w5>0 .and. w6>0 .and. l5>0 .and. l6>0																							
   
   ?
     txtpad=5-len(ltrim(str(Round(w5,0))))
   ? space(10), "Mat-2  A :", space(1), substr(ltrim(str(round(w5,0))),1,5), space(txtpad), ltrim(str(round((w5/cm),2))), space(3), mm2sixteen(w5),	space(2), mm2fract(W5)
     txtpad=5-len(ltrim(str(Round(w6,0))))                                                                                                                               
   ? space(10), "Mat-2  B :", space(1), substr(ltrim(str(round(w6,0))),1,5), space(txtpad), ltrim(str(round((w6/cm),2))), space(3), mm2sixteen(w6),	space(2), mm2fract(W6)
     txtpad=5-len(ltrim(str(Round(l5,0))))                                                                                                                               
   ? space(10), "Mat-2  C :", space(1), substr(ltrim(str(round(l5,0))),1,5), space(txtpad), ltrim(str(round((l5/cm),2))), space(3), mm2sixteen(L5),	space(2), mm2fract(L5)
     txtpad=5-len(ltrim(str(Round(l6,0))))                                                                                                                               
   ? space(10), "Mat-2  D :", space(1), substr(ltrim(str(round(l6,0))),1,5), space(txtpad), ltrim(str(round((l6/cm),2))), space(3), mm2sixteen(L6),	space(2), mm2fract(L6)
   endif
 
   if w7>0 .and. w8>0 .and. l7>0 .and. l8>0

   ?
     txtpad=5-len(ltrim(str(Round(w7,0))))
   ? space(10), "Mat-3  A :", space(1), substr(ltrim(str(Round(W7,0))),1,5), space(txtpad), ltrim(str(round((w7/cm),2))), space(3), mm2sixteen(w7),	space(2), mm2fract(W7)
     txtpad=5-len(ltrim(str(Round(w8,0))))                                                                                                                               
   ? space(10), "Mat-3  B :", space(1), substr(ltrim(str(Round(W8,0))),1,5), space(txtpad), ltrim(str(round((w8/cm),2))), space(3), mm2sixteen(w8),	space(2), mm2fract(W8)
     txtpad=5-len(ltrim(str(Round(l7,0))))                                                                                                                               
   ? space(10), "Mat-3  C :", space(1), substr(ltrim(str(Round(l7,0))),1,5), space(txtpad), ltrim(str(round((l7/cm),2))), space(3), mm2sixteen(L7),	space(2), mm2fract(L7)
     txtpad=5-len(ltrim(str(Round(l8,0))))                                                                                                                               
   ? space(10), "Mat-3  D :", space(1), substr(ltrim(str(Round(l8,0))),1,5), space(txtpad), ltrim(str(round((l8/cm),2))), space(3), mm2sixteen(L8),	space(2), mm2fract(L8)
   endif
   *
   ? space(5), "_____________________________________________________________"
   ?
   ? 
   ?
   set alternate off
   set alternate to
   if file ("AkelPad.Exe")
   Execute file "AkelPad.exe" Parameters "Kmat.txt"
   else
   Execute file "NotePad.exe" Parameters "Kmat.txt"
   endif
   endif
   RETURN NIL

************************************************************************************************

   * Pdf Report
   FUNCTION PdfPrt()
   Matcalc()
   if Kcalc > 0
    SELECT PRINTER DEFAULT TO PdfRpt PREVIEW
     If PdfRpt
      START PRINTDOC 
       START PRINTPAGE 
         @ 17,108 Print ltrim(trim(Kname)) Center Font "Lucenda Console" Size 13
         @ 21,108 Print "____________________________________________________________" Center Font "Lucenda Console" Size 11
         @ 27,118 print "mm          Inch(F)" Font "Lucenda Console" Size 9
         *  
         @ 33,103 Print "Matboard  Width" Font "Lucenda Console" Size 11 Right
         @ 33,108 print ":" Font "Lucenda Console" Size 11
         @ 33,123 Print alltrim(str(round(matw,0))) Font "Lucenda Console" Size 11 Right 
         @ 33,132 Print  mm2fract(round(matw,0)) Font "Lucenda Console" Size 11  
         @ 38,103 Print "Matboard  Length" Font "Lucenda Console" Size 11 Right
         @ 38,108 print ":" Font "Lucenda Console" Size 11
         @ 38,123 Print alltrim(str(round(matl,0))) Font "Lucenda Console" Size 11 Right 
         @ 38,132 Print mm2fract(round(matl,0)) Font "Lucenda Console" Size 11  
         * 
         @ 46,103 Print "Art-Photo  Width " Font "Lucenda Console" Size 11 Right
         @ 46,108 print ":" Font "Lucenda Console" Size 11
         @ 46,123 Print alltrim(str(round(picw,0))) Font "Lucenda Console" Size 11 Right 
         @ 46,132 Print mm2fract(round(picw,0)) Font "Lucenda Console" Size 11  
         @ 51,103 Print "Art-Photo  Length" Font "Lucenda Console" Size 11 Right
         @ 51,108 print ":" Font "Lucenda Console" Size 11
         @ 51,123 print alltrim(str(round(picl,0))) Font "Lucenda Console" Size 11 Right 
         @ 51,132 Print mm2fract(round(picl,0)) Font "Lucenda Console" Size 11  
         *
         @ 59,103 Print "Base Mat  Overlap " Font "Lucenda Console" Size 11 Right
         @ 59,108 print ":" Font "Lucenda Console" Size 11

         If overlap = 0.1
         @ 59,123 Print "0" Font "Lucenda Console" Size 11  Right
         else 
         @ 59,123 Print alltrim(str(round(overlap,1))) Font "Lucenda Console" Size 11  Right
         endif
         @ 59,132 Print mm2fract(round(overlap,1)) Font "Lucenda Console" Size 11  
         *
         @ 64,103 Print "Mat1 to Mat2 Setback" Font "Lucenda Console" Size 11 Right
         @ 64,108 print ":" Font "Lucenda Console" Size 11
         if m12 <> 0
         @ 64,123 Print alltrim(str(round(m12,0))) Font "Lucenda Console" Size 11  Right
         @ 64,132 Print mm2fract(round(m12,0)) Font "Lucenda Console" Size 11  
         else
         @ 64,123 Print "" Font "Lucenda Console" Size 11 Right
         endif 
         *
         @ 69,103 Print "Mat2 to Mat3 Setback" Font "Lucenda Console" Size 11 Right
         @ 69,108 print ":" Font "Lucenda Console" Size 11
         if m23 <> 0
         @ 69,123 Print alltrim(str(round(m23,0))) Font "Lucenda Console" Size 11 Right
         @ 69,132 Print mm2fract(round(m23,0)) Font "Lucenda Console" Size 11  
         else
         @ 69,123 Print "" Font "Lucenda Console" Size 11 Right
         endif
         @ 77,103 Print "Photo Width  Offset" Font "Lucenda Console" Size 11 Right 
         @ 77,108 print ":" Font "Lucenda Console" Size 11
         if offw <> 0
         @ 77,123 Print alltrim(str(round(offw,0))) Font "Lucenda Console" Size 11 Right 
         @ 77,132 Print mm2fract(round(offw,0)) Font "Lucenda Console" Size 11  
         else
         @ 77,123 Print "" Font "Lucenda Console" Size 11  Right
         endif
         @ 82,103 Print "Photo Length  Offset" Font "Lucenda Console" Size 11 Right
         @ 82,108 print ":" Font "Lucenda Console" Size 11
         if offl <> 0
         @ 82,123 Print alltrim(str(round(offl,0))) Font "Lucenda Console" Size 11 Right
         @ 82,132 Print mm2fract(round(offl,0)) Font "Lucenda Console" Size 11
         else
         @ 82,123 Print "" Font "Lucenda Console" Size 11 Right
         endif
         @ 90,103 Print "Photo Width Optical Center" Font "Lucenda Console" Size 11 Right
         @ 90,108 print ":" Font "Lucenda Console" Size 11
         @ 90,123 Print alltrim(str(t3)) Font "Lucenda Console" Size 11 Right 
         @ 90,132 Print mm2fract(round(t3,0)) Font "Lucenda Console" Size 11
         @ 95,103 Print "Photo Length Optical Center" Font "Lucenda Console" Size 11 Right
         @ 95,108 print ":" Font "Lucenda Console" Size 11
         @ 95,123 Print alltrim(str(u3)) Font "Lucenda Console" Size 11 Right
         @ 95,132 Print mm2fract(round(u3,0)) Font "Lucenda Console" Size 11

         @ 109,92 Print "Matboard Cut's" Font "Lucenda Console" Size 13
         @ 113,108 Print "____________________________________________________________" Center Font "Lucenda Console" Size 11
         @ 119,88 print "mm               Inch(D)              Inch(F)" Font "Lucenda Console" Size 9
         *
         @125,73  Print "Mat-1  Cut A" Font "Lucenda Console" Size 11 Right
         @125,78  print ":" Font "Lucenda Console" Size 11
         @125,93  Print alltrim(str(round(w3,0))) Font "Lucenda Console" Size 11 Right
         @125,100 print ":" Font "Lucenda Console" Size 11
         @125,115 Print alltrim(str(round((w3/cm),2))) Font "Lucenda Console" Size 11 Right
         @125,122 print ":" Font "Lucenda Console" Size 11
         @125,128 print mm2fract(W3) Font "Lucenda Console" Size 11
		*
         @130,73  Print "Mat-1  Cut B" Font "Lucenda Console" Size 11 Right
         @130,78  print ":" Font "Lucenda Console" Size 11
         @130,93  Print alltrim(str(round(w4,0))) Font "Lucenda Console" Size 11 Right
         @130,100 print ":" Font "Lucenda Console" Size 11
         @130,115 Print alltrim(str(round((w4/cm),2))) Font "Lucenda Console" Size 11 Right
         @130,122 print ":" Font "Lucenda Console" Size 11
         @130,128 print mm2fract(W4) Font "Lucenda Console" Size 11 
		*
         @135,73  Print "Mat-1  Cut C" Font "Lucenda Console" Size 11 Right
         @135,78  print ":" Font "Lucenda Console" Size 11
         @135,93  Print alltrim(str(round(l3,0))) Font "Lucenda Console" Size 11 Right
         @135,100 print ":" Font "Lucenda Console" Size 11
         @135,115 Print alltrim(str(round((l3/cm),2))) Font "Lucenda Console" Size 11 Right
         @135,122 print ":" Font "Lucenda Console" Size 11
         @135,128 print mm2fract(l3) Font "Lucenda Console" Size 11
		*
         @140,73  Print "Mat-1  Cut D" Font "Lucenda Console" Size 11 Right
         @140,78  print ":" Font "Lucenda Console" Size 11
         @140,93  Print alltrim(str(round(l4,0))) Font "Lucenda Console" Size 11 Right
         @140,100 print ":" Font "Lucenda Console" Size 11
         @140,115 Print alltrim(str(round((l4/cm),2))) Font "Lucenda Console" Size 11 Right
         @140,122 print ":" Font "Lucenda Console" Size 11
         @140,128 print mm2fract(l4) Font "Lucenda Console" Size 11
		*
      if w5>0 .and. w6>0 .and. l5>0 .and. l6>0
		*
         @150,73  Print "Mat-2  Cut A" Font "Lucenda Console" Size 11 Right
         @150,78  print ":" Font "Lucenda Console" Size 11
         @150,93  Print alltrim(str(round(w5,0))) Font "Lucenda Console" Size 11 Right
         @150,100 print ":" Font "Lucenda Console" Size 11
         @150,115 Print alltrim(str(round((w5/cm),2))) Font "Lucenda Console" Size 11 Right
         @150,122 print ":" Font "Lucenda Console" Size 11
         @150,128 print mm2fract(W5) Font "Lucenda Console" Size 11
		*
         @155,73  Print "Mat-2  Cut B" Font "Lucenda Console" Size 11 Right
         @155,78  print ":" Font "Lucenda Console" Size 11
         @155,93  Print alltrim(str(round(w6,0))) Font "Lucenda Console" Size 11 Right
         @155,100 print ":" Font "Lucenda Console" Size 11
         @155,115 Print alltrim(str(round((w6/cm),2))) Font "Lucenda Console" Size 11 Right
         @155,122 print ":" Font "Lucenda Console" Size 11
         @155,128 print mm2fract(W6) Font "Lucenda Console" Size 11
		*
         @160,73  Print "Mat-2  Cut C" Font "Lucenda Console" Size 11 Right
         @160,78  print ":" Font "Lucenda Console" Size 11
         @160,93  Print alltrim(str(round(l5,0))) Font "Lucenda Console" Size 11 Right
         @160,100 print ":" Font "Lucenda Console" Size 11
         @160,115 Print alltrim(str(round((l5/cm),2))) Font "Lucenda Console" Size 11 Right
         @160,122 print ":" Font "Lucenda Console" Size 11
         @160,128 print mm2fract(l5) Font "Lucenda Console" Size 11
		*
         @165,73  Print "Mat-2  Cut D" Font "Lucenda Console" Size 11 Right
         @165,78  print ":" Font "Lucenda Console" Size 11
         @165,93  Print alltrim(str(round(l6,0))) Font "Lucenda Console" Size 11 Right
         @165,100 print ":" Font "Lucenda Console" Size 11
         @165,115 Print alltrim(str(round((l6/cm),2))) Font "Lucenda Console" Size 11 Right
         @165,122 print ":" Font "Lucenda Console" Size 11
         @165,128 print mm2fract(l6) Font "Lucenda Console" Size 11
		*
      Endif
         * 
      if w7>0 .and. w8>0 .and. l7>0 .and. l8>0 
		*
         @175,73  Print "Mat-3  Cut A" Font "Lucenda Console" Size 11 Right
         @175,78  print ":" Font "Lucenda Console" Size 11
         @175,93  Print alltrim(str(round(w7,0))) Font "Lucenda Console" Size 11 Right
         @175,100 print ":" Font "Lucenda Console" Size 11
         @175,115 Print alltrim(str(round((w7/cm),2))) Font "Lucenda Console" Size 11 Right
         @175,122 print ":" Font "Lucenda Console" Size 11
         @175,128 print mm2fract(w7) Font "Lucenda Console" Size 11
		*
         @180,73  Print "Mat-3  Cut B" Font "Lucenda Console" Size 11 Right
         @180,78  print ":" Font "Lucenda Console" Size 11
         @180,93  Print alltrim(str(round(w8,0))) Font "Lucenda Console" Size 11 Right
         @180,100 print ":" Font "Lucenda Console" Size 11
         @180,115 Print alltrim(str(round((w8/cm),2))) Font "Lucenda Console" Size 11 Right
         @180,122 print ":" Font "Lucenda Console" Size 11
         @180,128 print mm2fract(w8) Font "Lucenda Console" Size 11
		*
         @185,73  Print "Mat-3  Cut C" Font "Lucenda Console" Size 11 Right
         @185,78  print ":" Font "Lucenda Console" Size 11
         @185,93  Print alltrim(str(round(l7,0))) Font "Lucenda Console" Size 11 Right
         @185,100 print ":" Font "Lucenda Console" Size 11
         @185,115 Print alltrim(str(round((l7/cm),2))) Font "Lucenda Console" Size 11 Right
         @185,122 print ":" Font "Lucenda Console" Size 11
         @185,128 print mm2fract(l7) Font "Lucenda Console" Size 11
		*
         @190,73  Print "Mat-3  Cut D" Font "Lucenda Console" Size 11 Right
         @190,78  print ":" Font "Lucenda Console" Size 11
         @190,93  Print alltrim(str(round(l8,0))) Font "Lucenda Console" Size 11 Right
         @190,100 print ":" Font "Lucenda Console" Size 11
         @190,115 Print alltrim(str(round((l8/cm),2))) Font "Lucenda Console" Size 11 Right
         @190,122 print ":" Font "Lucenda Console" Size 11
         @190,128 print mm2fract(l8) Font "Lucenda Console" Size 11
		*
    Endif 
     END PRINTPAGE             
   END PRINTDOC
  Endif
 Endif 
RETURN NIL 

************************************************************************************************

FUNCTION picload ()
local kurtebert
if Kcalc = 1
if Kphoto = 1
if Rpics = 1
*
CleanSlate ()
kurtebert := Getfile ( { {'All Files','*.jpg'} } , 'Get Photograph' , ' ' , .f. , .t. )
Form_1.img1.picture := kurtebert
if HV = 0
landscape ()
else
Portrait ()
endif
*
endif
endif
endif
RETURN NIL

************************************************************************************************

FUNCTION mm2sixteen(mm)
  LOCAL raw, inch, fraction, last, sixteen 
     IF mm >= 0
		raw      := (mm/25.4)
		inch     := int(raw)
		fraction := mod(raw,inch)
		*
		If fraction < 0.03125
		* Last = "0    "
		Last="0/16 "
		Endif
		If fraction >= 0.03125 .and. fraction < 0.09375
		Last ="1/16 "
		Endif
		if fraction >= 0.09375  .and. fraction < 0.15625
 		* Last= "1/8  "
		Last="2/16 "
		Endif
		if fraction >= 0.15625  .and. fraction < 0.21875
 		Last= "3/16 "
		Endif
		if fraction >= 0.21875  .and. fraction < 0.28125
 		* Last= "1/4  "
		Last="4/16 "
		Endif
		if fraction >= 0.28125  .and. fraction < 0.34375
 		Last= "5/16 "
		Endif
		if fraction >= 0.34375  .and. fraction < 0.40625
 		* Last= "3/8  "
		Last="6/16 "
		Endif
		if fraction >= 0.40625  .and. fraction < 0.46875
 		Last= "7/16 "
		Endif
		if fraction >= 0.46875  .and. fraction < 0.53125
		* Last= "1/2  "
		Last="8/16 "
		Endif
		if fraction >= 0.53125  .and. fraction < 0.59375
 		Last= "9/16 "
		Endif
		if fraction >= 0.59375  .and. fraction < 0.65625
		* Last= "5/8  "
		Last="10/16"
		Endif
		if fraction >= 0.65625  .and. fraction < 0.71875
		Last= "11/16"
		Endif
		if fraction >= 0.71875  .and. fraction < 0.78125
 		* Last= "3/4  "
		Last="12/16"
		Endif
		if fraction >= 0.78125  .and. fraction <0.84375
 		Last= "13/16"
		Endif
		if fraction >= 0.84375  .and. fraction < 0.90625
 		* Last= "7/8  "
		Last="14/16"
		Endif
		if fraction >= 0.90625  .and. fraction < 0.96875
 		Last= "15/16"
		Endif
		if fraction >= 0.96875  .and. fraction < 1.00000
		inch=inch+1
 		Last="0/16 "
		Endif
		*
		* Char(10)
		*
	 	sixteen  := str(inch,3,0)+":"+last 
     else
        sixteen  := "" 
     ENDIF
   RETURN sixteen

************************************************************************************************

FUNCTION mm2fract(mm)
  LOCAL raw, inch, fraction, last, sixteen 
     IF mm > 0
		raw      := (mm/25.4)
		inch     := int(raw)
		fraction := mod(raw,inch)
		*
		If fraction < 0.03125
		Last = "0    "
		* Last="0/16 "
		Endif
		If fraction >= 0.03125 .and. fraction < 0.09375
		Last ="1/16 "
		Endif
		if fraction >= 0.09375  .and. fraction < 0.15625
 		Last= "1/8  "
		* Last="2/16 "
		Endif
		if fraction >= 0.15625  .and. fraction < 0.21875
 		Last= "3/16 "
		Endif
		if fraction >= 0.21875  .and. fraction < 0.28125
 		Last= "1/4  "
		* Last="4/16 "
		Endif
		if fraction >= 0.28125  .and. fraction < 0.34375
 		Last= "5/16 "
		Endif
		if fraction >= 0.34375  .and. fraction < 0.40625
 		Last= "3/8  "
		* Last="6/16 "
		Endif
		if fraction >= 0.40625  .and. fraction < 0.46875
 		Last= "7/16 "
		Endif
		if fraction >= 0.46875  .and. fraction < 0.53125
		Last= "1/2  "
		* Last="8/16 "
		Endif
		if fraction >= 0.53125  .and. fraction < 0.59375
 		Last= "9/16 "
		Endif
		if fraction >= 0.59375  .and. fraction < 0.65625
		Last= "5/8  "
		* Last="10/16"
		Endif
		if fraction >= 0.65625  .and. fraction < 0.71875
		Last= "11/16"
		Endif
		if fraction >= 0.71875  .and. fraction < 0.78125
 		Last= "3/4  "
		* Last="12/16"
		Endif
		if fraction >= 0.78125  .and. fraction <0.84375
 		Last= "13/16"
		Endif
		if fraction >= 0.84375  .and. fraction < 0.90625
 		Last= "7/8  "
		* Last="14/16"
		Endif
		if fraction >= 0.90625  .and. fraction < 0.96875
 		Last= "15/16"
		Endif
		if fraction >= 0.96875  .and. fraction < 1.00000
		inch=inch+1
 		Last = "0    "
		Endif
		*
		sixteen  := str(inch,3,0)+":"+last  
     else
        sixteen  := ""
     ENDIF
   RETURN sixteen

************************************************************************************************
* End

