*******************************************************************************
*
*    Kloan - A Loan Payment Calculator
*    Copyright (C) 2016, Kurt Ebert
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the license, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see {<http:*www.gnu.org/licenses/>}
*
*    Web   : www.kurtebertphoto.com/kmat/
*    Email : kurt@kurtebertphoto.com
*
*******************************************************************************
*
*    Kloan Version 1.50 -- (11.7.2016)
*
*******************************************************************************

#include "hmg.ch"
d_declare ()
FUNCTION Main()
loan_var ()
loan_set ()
loan_win1 ()
RETURN NIL

* Kloan Ver 1.50

************************************************************************************************

FUNCTION loan_win1 ()
   DEFINE WINDOW Form_1 AT 100,100 WIDTH 615 HEIGHT 340 NOMAXIMIZE NOSIZE TITLE "Kloan Ver 1.50" MAIN 
   END WINDOW
   loan_keys ()
   loan_fields ()
   loan_buttons ()
   d_kmat_lic ()       
   d_kmat_help ()      
   d_main_menu ()      
   ACTIVATE WINDOW Form_1
   RETURN NIL

************************************************************************************************

FUNCTION loan_keys ()
ON KEY ESCAPE OF FORM_1 ACTION Form_1.Release
RETURN NIL

*******************************************************************************************

* declare help windows      
FUNCTION d_declare ()
   DECLARE WINDOW kmat_lic
   DECLARE WINDOW kmat_help
RETURN NIL

*******************************************************************************************

* License window            
FUNCTION d_kmat_lic ()
   DEFINE WINDOW kmat_lic AT 50,50 WIDTH 524 HEIGHT 417 TITLE 'License' NOSHOW NOAUTORELEASE

       DEFINE BUTTON Button_1
       ROW	340
       COL	211
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,170 LABEL L0  PARENT kmat_lic WIDTH 450 VALUE "Kloan - Loan Payment Calculator"
       @ 30,181 LABEL L1  PARENT kmat_lic WIDTH 450 VALUE "Copyrite (C) 2016, Kurt Ebert"
       @ 45,95  LABEL L2  PARENT kmat_lic WIDTH 450 VALUE ""
       @ 60,65  LABEL L3  PARENT kmat_lic WIDTH 450 VALUE "This program is free software: you can redistribute it and/or modify"
       @ 75,65  LABEL L4  PARENT kmat_lic WIDTH 450 VALUE "it under the terms of the GNU General Public License as published by"
       @ 90,65  LABEL L5  PARENT kmat_lic WIDTH 450 VALUE "the Free Software Foundation, version 3 of the license."
       @ 105,65 LABEL L6  PARENT kmat_lic WIDTH 450 VALUE ""
       @ 120,65 LABEL L7  PARENT kmat_lic WIDTH 450 VALUE "This program is distributed in the hope that it will be useful,"
       @ 135,65 LABEL L8  PARENT kmat_lic WIDTH 450 VALUE "but WITHOUT ANY WARRANTY; without even the implied warranty of"
       @ 150,65 LABEL L9  PARENT kmat_lic WIDTH 450 VALUE "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See"
       @ 165,65 LABEL L10 PARENT kmat_lic WIDTH 450 VALUE "the GNU General Public License for more details."
       @ 180,65 LABEL L11 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 195,65 LABEL L12 PARENT kmat_lic WIDTH 450 VALUE "You should have received a copy of the GNU General Public License"
       @ 210,65 LABEL L13 PARENT kmat_lic WIDTH 450 VALUE "along with this program. If not, see {<http://www.gnu.org/licenses/>}"
       @ 225,65 LABEL L14 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 240,65 LABEL L15 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 255,210 LABEL L16 PARENT kmat_lic WIDTH 450 VALUE "Contact Information"
       @ 280,179 hyperlink ip1 width 300 value "Email: kurt@kurtebertphoto.com" address "kurt@kurtebertphoto.com" handcursor
       @ 294,260 LABEL L17 PARENT kmat_lic WIDTH 25 VALUE "~"
       @ 306,184 hyperlink ip2 width 300 value "www.kurtebertphoto.com/kmat" address "http://kurtebertphoto.com/kmat" handcursor

   END WINDOW
RETURN NIL

************************************************************************************************

* Help Window
FUNCTION d_kmat_help ()             
   DEFINE WINDOW kmat_help AT 50,50 WIDTH 524 HEIGHT 305 TITLE 'Help' NOSHOW NOAUTORELEASE
 
       DEFINE BUTTON Button_2
       ROW	210
       COL	211
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,65  LABEL H0  PARENT kmat_help WIDTH 450 VALUE "First 3 fields are mandatory"
       @ 30,65  LABEL H1  PARENT kmat_help WIDTH 450 VALUE ""
       @ 45,65  LABEL H2  PARENT kmat_help WIDTH 450 VALUE "Decimal numbers without comma's"
       @ 60,65  LABEL H3  PARENT kmat_help WIDTH 450 VALUE ""
       @ 75,65  LABEL H4  PARENT kmat_help WIDTH 450 VALUE "Rate entered as whole percent 3.5 not 0.035"
       @ 90,65  LABEL H5  PARENT kmat_help WIDTH 450 VALUE ""
       @ 105,65 LABEL H6  PARENT kmat_help WIDTH 450 VALUE "0 percent rate is allowed"
       @ 120,65 LABEL H7  PARENT kmat_help WIDTH 450 VALUE ""
       @ 135,65 LABEL H8  PARENT kmat_help WIDTH 450 VALUE "Years as whole or decimal, 15 or 3.5"
       @ 150,65 LABEL H9  PARENT kmat_help WIDTH 450 VALUE ""
       @ 165,65 LABEL H10 PARENT kmat_help WIDTH 450 VALUE "Press the [ Calculate Button ]"
    END WINDOW
RETURN NIL

*******************************************************************************************

* define main menu                
FUNCTION d_main_menu ()
   DEFINE MAIN MENU OF Form_1
     DEFINE POPUP "File" 
         MENUITEM "Exit" ACTION Form_1.Release
      END POPUP 
      DEFINE POPUP "About" 
         MENUITEM "License" ACTION kmat_lic.Show
      END POPUP 
      DEFINE POPUP "Help" 
         MENUITEM "Help" ACTION kmat_help.Show
      END POPUP 
   END MENU
RETURN NIL

************************************************************************************************

Function loan_Fields ()
   @ 100, 35  LABEL L1 PARENT Form_1 WIDTH 100  VALUE "Loan Amount " bold
   @  97, 140 TEXTBOX V1 PARENT Form_1 WIDTH 100 NUMERIC 
   @ 150, 35  LABEL L2 PARENT Form_1 WIDTH 150  VALUE "Rate as Percent" bold
   @ 147, 188 TEXTBOX V2 PARENT Form_1 WIDTH 50 NUMERIC 
   @ 200, 35 LABEL L3 PARENT Form_1 WIDTH 150  VALUE  "Term in Years " bold
   @ 197, 188 TEXTBOX V3 PARENT Form_1 WIDTH 50 NUMERIC 
   *
   @ 100, 348  LABEL L4 PARENT Form_1 WIDTH 100  VALUE "Monthly Payment" bold
   @  97, 480 TEXTBOX V4 PARENT Form_1 WIDTH 75 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 150, 348  LABEL L5 PARENT Form_1 WIDTH 150  VALUE "Total Paid on Loan" bold
   @ 147, 480 TEXTBOX V5 PARENT Form_1 WIDTH 75 NUMERIC RIGHTALIGN NOTABSTOP READONLY 
   @ 200, 348 LABEL L6 PARENT Form_1 WIDTH 150  VALUE  "Total Interest Paid" bold
   @ 197, 480 TEXTBOX V6 PARENT Form_1 WIDTH 75 NUMERIC RIGHTALIGN NOTABSTOP READONLY 
   *
RETURN NIL

*******************************************************************************************

Function loan_Buttons ()
   @ 8,202  BUTTON B1 PARENT Form_1 CAPTION "Calculate" WIDTH 80 BOLD ONCLICK loan_good ()
   @ 8,322 BUTTON B2 PARENT Form_1 CAPTION "Clear Fields" WIDTH 80 BOLD ONCLICK loan_Clear ()
RETURN NIL

*******************************************************************************************

FUNCTION loan_var ()
Public LA,RP,Y,r,n,a,c,m,k,t,j,i,e
*
LA := 0
RP := 0
Y  := 0
r  := 0
n  := 0
a  := 0
c  := 0
m  := 0
k  := 0
t  := 0
j  := 0
i  := 0
e  := 0
*  
RETURN NIL

************************************************************************************************

FUNCTION loan_set ()
Set Navigation Extended
RETURN NIL

************************************************************************************************

FUNCTION loan_Clear ()
 loan_var ()
 Form_1.V1.value := 0
 Form_1.V2.value := 0
 Form_1.V3.value := 0
 Form_1.V4.value := 0
 Form_1.V5.value := 0
 Form_1.V6.value := 0
RETURN NIL

************************************************************************************************

FUNCTION Form_clear ()
 Form_1.V4.value := 0
 Form_1.V5.value := 0
 Form_1.V6.value := 0
RETURN NIL

************************************************************************************************


FUNCTION loan_good 
form_clear ()
 If Form_1.V1.value > 0 .and. Form_1.V2.value > 0 .and. Form_1.V3.value > 0
 *
 LA := Form_1.V1.value
 RP := Form_1.V2.value
 Y  := Form_1.V3.value
 *
 r := (RP/100)/12
 n := Y*12
 a := r*(1+r)^n
 c := ((1+r)^n)-1
 m := LA*(a/c)
 k := round(M,2)
 t := K*n
 j := round(T,2)
 i := round((j-LA),2)
 e := I*100
 *
 Form_1.V4.value := k
 Form_1.V5.value := j
 Form_1.V6.value := i
 *
 endif
 *
 If Form_1.V1.value > 0 .and. Form_1.V2.value = 0 .and. Form_1.V3.value > 0
 *
 form_clear ()
 *
 LA := Form_1.V1.value
 RP := Form_1.V2.value
 Y  := Form_1.V3.value
 n  := Y*12
 *
 Form_1.V4.value := round((LA/n),2)
 Form_1.V5.value := LA
 Form_1.V6.value := 0
 *
 endif
 *
RETURN NIL

************************************************************************************************
* End
