*******************************************************************************
*
*    Boiling Point Calculator
*    Copyright (C) 2016, Kurt Ebert
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the license, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see {<http:*www.gnu.org/licenses/>}
*
*    Web   : www.kurtebertphoto.com/kmat/
*    Email : kurt@kurtebertphoto.com
*
*******************************************************************************
*
*    Boiling Point Calculator --- Version 3.00 -- (12.7.2016)
*
*******************************************************************************

#include "hmg.ch"
bp_declare ()
FUNCTION Main()
bp_var ()
bp_set ()
bp_win1 ()
RETURN NIL

* Boiling Point Calculator --- Version 3.00

************************************************************************************************

FUNCTION bp_win1 ()
   DEFINE WINDOW Form_1 AT 100,100 WIDTH 615 HEIGHT 340 NOMAXIMIZE NOSIZE TITLE "Boiling Point Calculator  --- Ver 3.00" MAIN 
   END WINDOW
   bp_keys ()
   bp_fields ()
   bp_buttons ()
   d_bp_lic ()       
   d_bp_help ()      
   d_main_menu ()      
   ACTIVATE WINDOW Form_1
   RETURN NIL

************************************************************************************************

FUNCTION bp_keys ()
ON KEY ESCAPE OF FORM_1 ACTION Form_1.Release
RETURN NIL

*******************************************************************************************

* declare help windows      
FUNCTION bp_declare ()
   DECLARE WINDOW bp_lic
   DECLARE WINDOW bp_help
RETURN NIL

*******************************************************************************************

* License window            
FUNCTION d_bp_lic ()
   DEFINE WINDOW bp_lic AT 50,50 WIDTH 524 HEIGHT 417 TITLE 'License' NOSHOW NOAUTORELEASE

       DEFINE BUTTON Button_1
       ROW	340
       COL	211
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,170 LABEL L0  PARENT kmat_lic WIDTH 450 VALUE "Boiling Point Calculator --- Version 1.00"
       @ 30,181 LABEL L1  PARENT kmat_lic WIDTH 450 VALUE "Copyrite (C) 2016, Kurt Ebert"
       @ 45,95  LABEL L2  PARENT kmat_lic WIDTH 450 VALUE ""
       @ 60,65  LABEL L3  PARENT kmat_lic WIDTH 450 VALUE "This program is free software: you can redistribute it and/or modify"
       @ 75,65  LABEL L4  PARENT kmat_lic WIDTH 450 VALUE "it under the terms of the GNU General Public License as published by"
       @ 90,65  LABEL L5  PARENT kmat_lic WIDTH 450 VALUE "the Free Software Foundation, version 3 of the license."
       @ 105,65 LABEL L6  PARENT kmat_lic WIDTH 450 VALUE ""
       @ 120,65 LABEL L7  PARENT kmat_lic WIDTH 450 VALUE "This program is distributed in the hope that it will be useful,"
       @ 135,65 LABEL L8  PARENT kmat_lic WIDTH 450 VALUE "but WITHOUT ANY WARRANTY; without even the implied warranty of"
       @ 150,65 LABEL L9  PARENT kmat_lic WIDTH 450 VALUE "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See"
       @ 165,65 LABEL L10 PARENT kmat_lic WIDTH 450 VALUE "the GNU General Public License for more details."
       @ 180,65 LABEL L11 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 195,65 LABEL L12 PARENT kmat_lic WIDTH 450 VALUE "You should have received a copy of the GNU General Public License"
       @ 210,65 LABEL L13 PARENT kmat_lic WIDTH 450 VALUE "along with this program. If not, see {<http://www.gnu.org/licenses/>}"
       @ 225,65 LABEL L14 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 240,65 LABEL L15 PARENT kmat_lic WIDTH 450 VALUE ""
       @ 255,210 LABEL L16 PARENT kmat_lic WIDTH 450 VALUE "Contact Information"
       @ 280,179 hyperlink ip1 width 300 value "Email: kurt@kurtebertphoto.com" address "kurt@kurtebertphoto.com" handcursor
       @ 294,260 LABEL L17 PARENT kmat_lic WIDTH 25 VALUE "~"
       @ 306,184 hyperlink ip2 width 300 value "www.kurtebertphoto.com/kmat" address "http://kurtebertphoto.com/kmat" handcursor

   END WINDOW
RETURN NIL

************************************************************************************************

* Help Window
FUNCTION d_bp_help ()             
   DEFINE WINDOW bp_help AT 50,50 WIDTH 524 HEIGHT 305 TITLE 'Help' NOSHOW NOAUTORELEASE
 
       DEFINE BUTTON Button_2
       ROW	210
       COL	211
       CAPTION 'Close'
       ACTION	ThisWindow.Hide
       END BUTTON

       @ 15,65  LABEL H0  PARENT kmat_help WIDTH 450 VALUE ""
       @ 30,65  LABEL H1  PARENT kmat_help WIDTH 450 VALUE "Decimal numbers no comma's"
       @ 45,65  LABEL H2  PARENT kmat_help WIDTH 450 VALUE ""
       @ 60,65  LABEL H3  PARENT kmat_help WIDTH 450 VALUE "Elevation >= 0"
       @ 75,65  LABEL H4  PARENT kmat_help WIDTH 450 VALUE ""
       @ 90,65  LABEL H5  PARENT kmat_help WIDTH 450 VALUE "Pressure >= 27 and <= 32"
       @ 105,65 LABEL H6  PARENT kmat_help WIDTH 450 VALUE ""
       @ 120,65 LABEL H7  PARENT kmat_help WIDTH 450 VALUE "Tab to switch Fields"
       @ 135,65 LABEL H8  PARENT kmat_help WIDTH 450 VALUE ""
       @ 150,65 LABEL H9  PARENT kmat_help WIDTH 450 VALUE ""
       @ 165,65 LABEL H10 PARENT kmat_help WIDTH 450 VALUE ""
    END WINDOW
RETURN NIL

*******************************************************************************************

* define main menu                
FUNCTION d_main_menu ()
   DEFINE MAIN MENU OF Form_1
     DEFINE POPUP "File" 
         MENUITEM "Exit" ACTION Form_1.Release
      END POPUP 
      DEFINE POPUP "About" 
         MENUITEM "License" ACTION bp_lic.Show
      END POPUP 
      DEFINE POPUP "Help" 
         MENUITEM "Help" ACTION bp_help.Show
      END POPUP 
   END MENU
RETURN NIL

************************************************************************************************

FUNCTION bp_Clear ()
 bp_var ()
 Form_1.V1.value := 0
 Form_1.V2.value := 0
RETURN NIL

************************************************************************************************

Function bp_fields ()
   @ 100, 35  LABEL L1 PARENT Form_1 WIDTH 160  RIGHTALIGN VALUE "Elevation  (Feet)" bold
   @  97, 210 TEXTBOX V1 PARENT Form_1 WIDTH 60 NUMERIC 
   @ 150, 35  LABEL L2 PARENT Form_1 WIDTH 160  RIGHTALIGN VALUE "Barometric Pressure  (inHg)" bold
   @ 147, 210 TEXTBOX V2 PARENT Form_1 WIDTH 60 NUMERIC 
   *
   @ 100, 300  LABEL L3 PARENT Form_1 WIDTH 170  RIGHTALIGN VALUE "Boiling Point by Elevation (F)" bold
   @  97, 500 TEXTBOX V3 PARENT Form_1 WIDTH 60 NUMERIC RIGHTALIGN NOTABSTOP READONLY
   @ 150, 300  LABEL L4 PARENT Form_1 WIDTH 170  RIGHTALIGN VALUE "Pressure Correction (F)" bold
   @ 147, 500 TEXTBOX V4 PARENT Form_1 WIDTH 60 NUMERIC RIGHTALIGN NOTABSTOP READONLY 
   @ 200, 300 LABEL L5 PARENT Form_1 WIDTH 170  RIGHTALIGN VALUE  "Corrected Boiling Point (F)" bold
   @ 197, 500 TEXTBOX V5 PARENT Form_1 WIDTH 60 NUMERIC RIGHTALIGN NOTABSTOP READONLY 
   *
RETURN NIL

*******************************************************************************************

Function bp_buttons ()
   @ 12,285  BUTTON B1 PARENT Form_1 CAPTION "Calculate" WIDTH 80 BOLD ONCLICK bp_good ()
RETURN NIL

*******************************************************************************************

FUNCTION bp_var ()
Public Elev, Etemp, Pres, Ptemp, Ctemp, A, B, C, D, E, F, G, H, J
Public Etemp2, Etemp3, Ptemp2, Ptemp3, Ctemp2, Ctemp3
*
Elev   := 0
Pres   := 0
*
Etemp  := 0
Etemp2 := 0
Etemp3 := 0
Ptemp  := 0
Ptemp2 := 0
Ptemp3 := 0
Ctemp  := 0
Ctemp2 := 0
Ctemp3 := 0
*
A := 0
B := 0         
C := 0              
D := 0          
E := 0              
F := 0            
G := 0         
H := 0         
J := 0         
*           
RETURN NIL

************************************************************************************************

FUNCTION bp_set ()
Set Navigation Extended
RETURN NIL

************************************************************************************************

FUNCTION Form_clear ()
 Form_1.V3.value := 0
 Form_1.V3.value := 0
 Form_1.V5.value := 0
RETURN NIL

************************************************************************************************


FUNCTION bp_good 
form_clear ()
if Form_1.V2.value = 0
Form_1.V2.value := 29.921
endif
*
If Form_1.V1.value >= 0 .and. Form_1.V2.value >= 27 .and. Form_1.V2.value <= 32 
 *
Elev := Form_1.V1.value
Pres := Form_1.V2.value
 *
A := 1-(6.8753*0.000001*Elev)
B := 5.2559            
C := A^B                 
D := 29.921             
E := C*D                
F := 49.161             
G := Log(E)              
H := 44.932 
J := Log(Pres)            
Etemp  := (F*G)+H 
Etemp2 := 212-((Elev)*(0.00184))
Etemp3 := (Etemp+Etemp2)/2
Ptemp  := ((F*J)+H)-212
Ptemp2 := (1.67)*(Pres-29.921)
Ptemp3 := (Ptemp+Ptemp2)/2
Ctemp  := Etemp+Ptemp
Ctemp2 := Etemp2+Ptemp2
Ctemp3 := (Ctemp+Ctemp2)/2            
*
if Elev=0 .and. Pres=29.921
Form_1.V3.value := Round(Etemp2,2)
Form_1.V4.value := Round(Ptemp2,2)
Form_1.V5.value := Round(Ctemp2,2)
else
Form_1.V3.value := Round(Etemp3,2)
Form_1.V4.value := Round(Ptemp3,2)
Form_1.V5.value := Round(Ctemp3,2)
endif
 *
else
bp_clear()
Form_clear ()
endif
RETURN NIL

************************************************************************************************
* End
